<?php
   // bobg 22jun11 voicemail escape added 12sep 2nov
	// All script inside these brackets (less than question mark and question mark greater than) is PHP script
	// all other script is VXML
    // ini_set("url_rewriter.tags", "");
    // session_start();
    // error_reporting(0);
    print "<?xml version=\"1.0\" ?>\n";
?>
<!DOCTYPE vxml PUBLIC "SpeechBrowser/2.0/DTD" "ignore" >
<vxml version="2.0">

<?php
// ************************************************
// This file is a template for normal Callback When Reaching top of Queue
// it allows a caller to set a callback whilst queueing and then be called back
// when the caller would have got to the top of the queue
// it then calls the originator back and then transfers the original caller back to the target when answered
// to ensure that the caller is placed at the top of the queue you need to redial with
// a DialPriority prefix!
// ALSO this can be used from remote mobile phones, and external callers!
// Press 1 whilst in a queue
// ************************************************

	// ************************************************
	// Change the following to match your CONFIGURATION
   // typically $vmportname = "BuiltIn", $vmportlocation =""
	$vmportname     = "BuiltIn";
	$vmportlocation = "";

   $positionInQ = 0; //0=disable 1=enable
   $callback    = 0; //0=disable 1=enable
   $voicemail   = 0; //0=disable 1 thru 9 to enable also used as keyed digit to select

	// The following can be used if hosted on the actual call server if not proper authentication is required
    $server        = "127.0.0.1";
    $user_login    = "INTERNAL";
    $user_password = "123456";

    $failedtelephonenumber = "8000";
    $retrymax              = "5";
    $retryinterval         = "30";

    $DialPriority_prefix  = "*42";  //Dial Plan entry required: *42 / Dial Proprity / %r
    $DialVoicemail_prefix = "#";    //Dial Plan entry required: #   / Dial          / !%r

    // ************************************************

	$hostname = $_SERVER['SERVER_NAME'];
	$filename = substr($_SERVER['SCRIPT_NAME'],1);

	// Now pickup the standard always present parameters (source number and command)
	
	if ($_SERVER['SERVER_PORT'])				// We are running from a web server
	{
    	$cmd = $_REQUEST['cmd'];
	    $num = $_REQUEST['s'];
	    $target = $_REQUEST['t'];
	    $crguid = $_REQUEST['g'];
	    $pos = $_REQUEST['q'];
	    $orignum = $_REQUEST['o'];
	}
	else                                        // We are running from the command line for testing
	{
		$cmd = $argv[1];
		$num = $argv[2];
		$target = $argv[3];
		$crguid = $argv[4];
		$pos = $argv[5];
		$orignum = $argv[6];
		print "cmd=$cmd num=$num target=$target crguid=$crguid pos=$pos orignum=$orignum\n";
    }
    $organiser = $target.$filename.$num;

//$pos=6;
	// Now interpet the specific command
   if ($cmd == "")														// DEFAULT Command to Ask what to do - create or cancel
   {
      if(!$positionInQ) $pos=0;
      if( $pos <= 1 )
      {
         print "<form id=\"headofqueue\">\n";
         if($positionInQ and $voicemail) print "<field name=\"keyed\" type=\"digits?\">\n";
         if ($positionInQ and !$voicemail) print "<block>\n";
         if ($positionInQ) print "<prompt>You are already at the head of the queue.</prompt>\n";
         if ($positionInQ) print "<prompt>Please continue to hold</prompt>\n";
         if ($positionInQ and $voicemail) print "<prompt timeout=\"3s\">or press $voicemail to leave a voicemail.</prompt>\n";
         if ($positionInQ and $voicemail) print "<filled>\n";
         if ($positionInQ and $voicemail) print "<if cond=\"keyed==='$voicemail'\">\n";
         if ($positionInQ and $voicemail) print "<prompt bargein=\"false\">Please hold</prompt>\n";
         if (!$positionInQ and $voicemail) print "<block>\n<prompt bargein=\"false\">Please hold</prompt>\n";
         if ($voicemail) print "<goto next=\"$filename?cmd=voicemail&amp;s=$num&amp;t=$target&amp;g=$crguid&amp;o=$num\"/>\n";
         if (!$positionInQ and $voicemail) print "</block>\n";
         if ($positionInQ and $voicemail) print "</if>\n";
         if ($positionInQ and $voicemail) print "<disconnect/>\n";
         if ($positionInQ and $voicemail) print "</filled>\n";
         if ($positionInQ and $voicemail) print "<noinput>\n";
         if ($positionInQ and $voicemail) print "<disconnect/>\n";
         if ($positionInQ and $voicemail) print "</noinput>\n";
         if ($positionInQ and $voicemail) print "</field>\n";
         if ($positionInQ and !$voicemail) print "</block>\n";
         print "</form>\n";
        }
        else
        {
            // Lets lookup the name of the calling party    
            if( $num )
            {
                $ds = LdapConnect($server,$user_login,$user_password);
                $name = LdapGetName($ds,$num);
                $vmport = LdapGetVmPort($ds,$vmportname,$vmportlocation);
                if ($vmport=="notfound") print ("\n<form><block>ERROR - Check voicemail settings in script. ERROR</block></form>\n");

                // Now look for a previous setting
                $sr=@ldap_search($ds, "guid=$vmport", "(&(objectclass=ScheduledCall)(organiser=$organiser))");
                $o = @ldap_get_entries($ds, $sr);
                if ($o['count'] != 0)
                {
                    $cur_starttime = $o[0]['starttime'][0];
                    $cur_startdate = $o[0]['startdate'][0];
                }
                LdapClose($ds);
            }
?>
 		<form id="menu">
            <field name="keyed" type="digits?">
<?php
            if( $name )
            {
                print "<prompt>hello</prompt>\n";
                SpeakName($name,$num);
            }
?>
            <prompt>Welcome to the Splice com maximiser system.</prompt>
<?php
            print "<prompt>You are currently at position</prompt>\n";
            print "<prompt>$pos</prompt>\n";

            if( $cur_starttime ) 
				   print "<prompt>You already have a call back waiting</prompt>\n";
            if( $num ) 
				   if ($callback) print "<prompt>Press 1 to be called back on the number you are calling from</prompt>\n";
            
			   if ($callback) print "<prompt>Press 2 to enter the number to call back</prompt>\n";
            
            if( $cur_starttime )
				if ($callback) print "<prompt>Press 3 to cancel the call back</prompt>\n";

				if ($voicemail) print "<prompt>Press $voicemail to leave a voicemail</prompt>\n";

            print "<prompt timeout=\"3s\">Or continue to hold</prompt>\n<filled>\n";

            if( $num )
			      if ($callback) print "<if cond=\"keyed==='1'\">\n<goto next=\"$filename?cmd=submit&amp;s=$num&amp;t=$target&amp;g=$crguid&amp;o=$num\"/>\n</if>\n";
            
            if ($callback) print "<if cond=\"keyed==='2'\">\n<goto next=\"$filename?cmd=getnum&amp;s=$num&amp;t=$target&amp;g=$crguid&amp;o=$num\"/>\n</if>\n";
            
            if( $cur_starttime )
                if ($callback) print "<if cond=\"keyed==='3'\">\n<goto next=\"$filename?cmd=cancel&amp;s=$num&amp;t=$target&amp;g=$crguid&amp;o=$num\"/>\n</if>\n";

            print "<if cond=\"keyed==='$voicemail'\">\n<prompt bargein=\"false\">\nPlease hold\n</prompt>\n<goto next=\"$filename?cmd=voicemail&amp;s=$num&amp;t=$target&amp;g=$crguid&amp;o=$num\"/>\n</if>\n";
 ?>
				</filled>
				<noinput>
      				<goto next="#mydisconnect"/>
    			</noinput>
			</field>
		</form>
       
        <form id="mydisconnect">
            <block>
                <disconnect/>
            </block>
        </form>
<?php
        }
    }
    else if ($cmd == "getnum")											// getnum and wakeup call prompt in 24hr format
    {
?>
        <form id="setup">
            <catch event="telephone.disconnect.hangup">
                <exit/>
            </catch>
            
            <var name="cmd" expr="'submit'"/>
<?php
            print "<var name=\"t\" expr=\"'$target'\"/>\n";
            print "<var name=\"g\" expr=\"'$crguid'\"/>\n";
            print "<var name=\"o\" expr=\"'$orignum'\"/>\n";
?>
            <field name="s" type="digits">
                <property name="timeout" value="10s"/>
                <property name="bargein" value="true"/>
                <prompt>Enter the number to call back, followed by the hash key</prompt>
                <filled>
<?php
  				print "<submit next=\"$filename\" enctype=\"multipart/form-data\" method=\"post\" namelist=\"cmd s t g o\"/>\n";
?>
                </filled>
            </field>
        </form>
        
<?php
    }
    else if ($cmd == "submit")										// SUBMIT this form to the database after user enter correct format
    {
        // check for existing scheduled call
        // if found, delete it
        $ds = LdapConnect($server,$user_login,$user_password);
        if ($ds)
        {
            $vmport = LdapGetVmPort($ds,$vmportname,$vmportlocation);
            $sr=ldap_search($ds, "guid=$vmport", "(&(objectclass=ScheduledCall)(organiser=$organiser))"); 
            $o = ldap_get_entries($ds, $sr);
            if ($o['count'] != 0)
            {
                $guid = $o[0]['guid'][0];
                ldap_delete($ds, "guid=$guid");
            }
            
            // add new scheduled call
            $date = getdate( time()+(1*60*60) );      // Add an hour
            $start_hour = $date['hours'];
            $start_min  = $date['minutes'];
            $starttime = sprintf("%02d%02d",$start_hour,$start_min);

            $attr['objectclass']            = "ScheduledCall";
            $attr['organiser']              = $organiser;
            $attr['starttime']              = $starttime;
            $attr['notes']                  = "$crguid";
            $attr['telephonenumber']        = $num;
            $attr['command']                = "!EA:http://$hostname/$filename?cmd=callback&n=$num&t=$target&g=$crguid";
            $attr['failtelephonenumber']    = $failedtelephonenumber;
            $attr['failcommand']            = "!EA:http://$hostname/$filename?cmd=alarm&n=$num&t=$target&g=$crguid";
            $attr['retryinterval']          = $retryinterval;
            $attr['retrymax']               = $retrymax;
            $dn = "datetime=".gmdate("ymdHis").",guid=$vmport";
            ldap_add($ds, $dn, $attr);
            LdapClose($ds);
        }
?>
			<form id="submit">
				<block>
<?php
            if( $num != $orignum )
            {
                print "<prompt>You will be called back on</prompt>\n";
                SpeakName("",$num);
                print "<prompt>when you would have reached the top of the queue</prompt>\n";
            }
            else
            {
                print "<prompt>You will be called back when you would have reached the top of the queue</prompt>\n";
            }
			print "<prompt>Please Hang Up. Thank you</prompt>\n";
?>
				</block>
			</form>
<?php
    }
    else if ($cmd == "cancel")												// CANCEL alarm call on this extension
    {
        // check for existing scheduled call
        // if found, delete it
		$ds = LdapConnect($server,$user_login,$user_password);
        if ($ds)
        {
			$name = LdapGetName($ds,$num);
		    $vmport = LdapGetVmPort($ds,$vmportname,$vmportlocation);
            $sr=ldap_search($ds, "guid=$vmport", "(&(objectclass=ScheduledCall)(organiser=$organiser))"); 
            $o = ldap_get_entries($ds, $sr);
            if ($o['count'] != 0)
            {
                $guid = $o[0]['guid'][0];
                ldap_delete($ds, "guid=$guid");
            }
            LdapClose($ds);
        }
?>
        <form id="cancel">
            <block>
                <prompt>call back canceled for</prompt>
<?php
				SpeakName($name,$num);
?>
            </block>
        </form>
        
<?php
    }
    else if ($cmd == "callback")												// Callback has worked has gone off
    {
		$ds=LdapConnect($server,$user_login,$user_password);
		$name = LdapGetName($ds,$target);
		LdapClose($ds);
?>
        <form id="callback">
            <block>
                <prompt>You requested a call back from SpliceCom</prompt>
                <prompt>You are now being placed at the head of the queue for </prompt>
<?php
                SpeakName($name,$target);
?>
            </block>
<?php
            print "<transfer name=\"call\" dest=\"$DialPriority_prefix$target\">\n</transfer>\n";
?>
        </form>
<?php
    }
    else if ($cmd == "alarm")												// ALARM has gone off
    {
        $ds=LdapConnect($server,$user_login,$user_password);
        $name = LdapGetName($ds,$num);
        $tname = LdapGetName($ds,$target);
        LdapClose($ds);
?>
        <form id="alarm">
            <block>
<?php
            for($i=1; $i < 5; $i++)
            {
                print "<prompt>Call back request failed for </prompt>\n";
                SpeakName($name,$num);
                print "<prompt> to </prompt>\n";
                SpeakName($tname,$target);
            }
?>
            <prompt>Goodbye</prompt>
            <disconnect/>
            </block>
        </form>
<?php
    } else if ($cmd=="voicemail")
    {
?>
      <form id="voicemail">
         <block>
            <disconnect/>
         </block>
      </form>
<?php
      $ds=LdapConnect($server,$user_login,$user_password);

	   $sr = ldap_read($ds,"cn=System","objectclass=*");
   	$info = ldap_get_entries($ds,$sr);
	   $passwd=$info[0]['callloggingpassword'][0];
   	ldap_close($ds);
	   //open tcpip connection to the Call Routing Control Port
   	$fp = fsockopen ("127.0.0.1", 4005, $errno, $errstr, 5);
	   stream_set_blocking($fp, false);
   	sleep(1);
	   $r="login,$passwd\n";
   	fputs ($fp, $r);
	   sleep (1);
   	fread($fp,1024);
	   $r ="redirectto,$crguid,$DialVoicemail_prefix$target\n"; // this redirectto kills original queue link
   	fputs ($fp, $r);
	   sleep(1);
   	fclose($fp);
    }
    else
    {
?>
        <form>
            <block>
                <prompt>I am sorry I do not understand the command</prompt>
<?php
				print "<prompt>$cmd</prompt>"; 
?>
            </block>
        </form>
<?php
    }
?>
</vxml>

<?php
// Helpful functions to make the above code easier
function LdapConnect($server,$user_login,$user_password)
{
    $ds=ldap_connect($server.":4000");  // must be a valid LDAP server!
    if ($ds)
    {
        $r=ldap_bind($ds, $user_login, $user_password);
        if (!$r)
        {
            ldap_close($ds);
            $ds = 0;
        }
    }
    return $ds;
}

function LdapClose($ds)
{
    ldap_close($ds);
}

function LdapGetName($ds,$num)
{
	$name = "";
	if ($num != "" && $ds)
	{
		$sr=ldap_search($ds, "", "(GlobalTelephoneNumber=$num)",array("cn"),0,1); 	// Optimized special key search
		$o = ldap_get_entries($ds, $sr);
		if ($o['count'] != 0)					// If we have some answers
		{  
			$name = $o[0]['cn'][0];				// Extract the name (common name = cn) attribute
		}
	}
	return $name;
}

function LdapGetVmPort($ds,$vmportname,$vmportlocation)
{
    if( $vmportlocation )
    {
        $sr=@ldap_read($ds, "cn=$vmportlocation,cn=Modules","(objectclass=Module)",array("guid","cn"),0,1);
        $o = @ldap_get_entries($ds, $sr);
        if ($o['count'] != 0)
        {
            $location = $o[0]['guid'][0];
        }
    }
    else
    {
        $location = "00000000-0000-0000-0000-000000000000";
    }

    if( $location )
    {
		$sr=@ldap_list($ds, "cn=VoicemailPorts","(&(location=$location)(cn=$vmportname))",array("guid","cn"),0,0);
		$o = @ldap_get_entries($ds, $sr);
		if ($o['count'] != 0)
		{
			$vmport = $o[0]['guid'][0];
			return $vmport;
		}
	}
	return "notfound";
}

function SpeakName($name,$num)
{
	if( $name!="" )
    {
        print "<prompt>$name</prompt>\n";
    }
    else
    {
        print "<prompt>Number </prompt>\n";
        for ($i=0; $num[$i] != ""; $i++)
        {
            print "<prompt>$num[$i]</prompt>\n";
        }
    }
}

function SpeakTime($t)
{
    if( strlen($t) == 3 )
    {
        $t="0".$t;
    }
    else if( strlen($t) == 2 )
    {
        $t="00".$t;
    }
	$hour = substr($t, -4, 2);
	$min = substr($t, -2, 2);
	if( $min == "00" )
	{
		$min = " hundred hours";
	}
    print "<prompt>$hour</prompt>\n";
    print "<prompt>$min</prompt>\n";
}
?>

