<?php
// bobg 10jul09 9aug 15apr10 18apr 1sep 4jan12 8feb 27feb 29mar12
// PJC 17/06/2013 - updated warning location details
// PJC 16/05/2014 - SSD Update
// PJC 09/03/2015 - Warn if inbound or outbound recording departments have a current home set
// PJC 16/06/2015 - UPDATE checking of inbound or outbound recording departments
// PJC 21/07/2015 - Check for Public (Internet) IP Address
// PJC 25/04/2019 - Check for Select User Password


include "assist/tzone.php"; // include timezone
if (isset($_SERVER['HTTP_HOST'])) die("Run from command line.");
$script=basename($_SERVER['SCRIPT_NAME']);

function warning($s) {
   global $ds,$script;
   $item = array ('dowarning'=> "$script: ".$s);
   ldap_modify($ds,"cn=Commands",$item);
}
$ds=ldap_connect("127.0.0.1",4000);
$r=ldap_bind($ds,"INTERNAL","00112233445566");


// select userpassword
$sr=@ldap_search($ds,"cn=System","(&(objectclass=Administrator)(cn=Select))",array('userpassword'));
$info=ldap_get_entries($ds,$sr); 
if (isset($info[0]['userpassword'][0])) {
	if (trim(strtolower($info[0]['userpassword'][0])) == 'adminportal') {
		warning ("Select User has a default password set");
	}
}


// free disk space
$a=array();
$cmd = "df | grep /dev/";
exec($cmd,$a);
foreach($a as $k => $v) {
   sscanf($v,"%s %s %s %s %s %s", $filesystem, $size, $used, $avail, $usedp, $mountpoint);
	if ($usedp >= 80) warning("DISK: $mountpoint is $usedp full.");
}

// restart _1234.log files
$a=array();
$cmd = "ls -l /SpliceCom/logs/* | grep _[0123456789]";
exec($cmd,$a,$rv);
if ($rv==255) warning ("Thousands of restart files /SpliceCom/logs/*_*.log");
elseif($rv>1) warning ("errno=$rv, cmd=$cmd\n");
elseif (count($a)) warning (count($a)." restart files /SpliceCom/logs/*_*.log");

// vision _1234.log files
$a=array();
$cmd = "ls -l /SpliceCom/ftp/* | grep _[0123456789]";
exec($cmd,$a, $rv);
if ($rv==255) warning ("Thousands of Vision log files /SpliceCom/ftp/*_*.log");
elseif($rv>1) warning ("errno=$rv, cmd=$cmd\n");
elseif (count($a)>99) warning (count($a)." Vision log files /SpliceCom/ftp/*_*.log");

// Archive files
$a=array();
$cmd = "ls -l /SpliceCom/Mailbox/Archive/";
exec($cmd,$a,$rv);
if ($rv==255) warning ("Thousands of Voicemail Archive files /SpliceCom/Mailbox/Archive/");
elseif($rv>1) warning ("errno=$rv, cmd=$cmd\n");
elseif (count($a)>99) warning (count($a)." Voicemail Archive files");

// build array of nodes  and note those not seen for 10 days
$sr=@ldap_list($ds,"cn=Modules","(&(objectclass=Module)(modulestatus=0))");
$info=ldap_get_entries($ds,$sr);

for($n=0; $n<$info['count'];$n++) {
    if ($info[$n]['moduletype'][0]==1 and substr($info[$n]['serialnumber'][0],0,8)!="00-07-d9") $type="XS";
    elseif ($info[$n]['moduletype'][0]==1) $type="4100";
    elseif ($info[$n]['moduletype'][0]==2) continue; //$type="4200";
    elseif ($info[$n]['moduletype'][0]==3) $type="4315";
    elseif ($info[$n]['moduletype'][0]==4) $type="4330";
    elseif ($info[$n]['moduletype'][0]==7) continue; //$type="VoIP";
    elseif ($info[$n]['moduletype'][0]==8) continue; //$type="4400";
    elseif ($info[$n]['moduletype'][0]==10) $type="4140";
    elseif ($info[$n]['moduletype'][0]==11) $type="5100";
    elseif ($info[$n]['moduletype'][0]==12) $type="5108";
    elseif ($info[$n]['moduletype'][0]==13) $type="5330";
    elseif ($info[$n]['moduletype'][0]==14) $type="5315";
    elseif ($info[$n]['moduletype'][0]==17) $type="S8000-Linux";
    elseif ($info[$n]['moduletype'][0]==18) $type="S8000-Apple";
    elseif ($info[$n]['moduletype'][0]==19) $type="NSG";
    else continue;
    $days=floor((time()-$info[$n]['lastseen'][0])/(24*60*60));
    if ($days>9 and $days<30) warning("'".$info[$n]['cn'][0]."' $type module, last seen @ ".date("H:i:s l, jS F Y",$info[$n]['lastseen'][0])." - Act now, or PANIC in ".(30-$days)." days time!");

    // auto add phones enabled
    $sr1=@ldap_list($ds,$info[$n]['dn'],"(&(objectclass=AdministrationModule)(autoAddPhones=1))");
    $info1=ldap_get_entries($ds,$sr1);
    if ($info1['count']) warning("Module ".$info[$n]['cn'][0]." has Auto Add Phones enabled");
}
// WANLink password
$sr=@ldap_search($ds,"cn=Modules","(&(objectclass=WANLink)(cn=WANLink)(accountpasswordin=password))");
$info=ldap_get_entries($ds,$sr);
for($n=0; $n<$info['count'];$n++) {
    $s=str_replace('cn=','',$info[$n]['dn']);
    $sa=explode(',',$s);
    warning ("WANLink $sa[0] in Module $sa[1] has a default password");
}
// User/Department voicemail password
$sr=@ldap_list($ds,"cn=Users","(&(objectclass=User)(voicemailaccesscode=1234))",array('dn','cn','telephonenumber'));
$info=ldap_get_entries($ds,$sr);
for($n=0; $n<$info['count'];$n++) {
   if (isset($argv[1]) and ctype_digit($argv[1]) and $argv[1]>999){
      $pin=$info[$n]['telephonenumber'][0]+$argv[1];
      $att=array('voicemailaccesscode'=>$pin);
      $end=" - changed to $pin";
      ldap_modify($ds,$info[$n]['dn'],$att);
   } else $end="";
   warning ("User ".$info[$n]['cn'][0]."/".$info[$n]['telephonenumber'][0]." has a voicemail password of 1234$end");
}
$sr=@ldap_list($ds,"cn=Departments","(&(objectclass=Department)(voicemailaccesscode=1234))",array('cn','telephonenumber'));
$info=ldap_get_entries($ds,$sr);
for($n=0; $n<$info['count'];$n++) {
   if (isset($argv[1]) and ctype_digit($argv[1]) and $argv[1]>999){
      $pin=$info[$n]['telephonenumber'][0]+$argv[1];
      $att=array('voicemailaccesscode'=>$pin);
      $end=" - changed to $pin";
      ldap_modify($ds,$info[$n]['dn'],$att);
   } else $end="";
   warning ("Department ".$info[$n]['cn'][0]."/".$info[$n]['telephonenumber'][0]." has a voicemail password of 1234$end");
}

//OutboundRecording
$blank = "00000000-0000-0000-0000-000000000000";
$sr=ldap_list($ds, "cn=departments", "(&(cn=OutboundRecordings)(objectclass=department))", array("currenthome","guid"));
$info = ldap_get_entries($ds, $sr); $out = (isset($info[0]['currenthome'][0])) ? $info[0]['currenthome'][0] : NULL;
if ($out != NULL) {
	if ($out != $blank) {
	  	echo "OutboundRecording Department - current home set\r\n";
	  	warning("OutboundRecording Department - current home set");
 	}
}
//InboundRecording
$sr=ldap_list($ds, "cn=departments", "(&(cn=InboundRecordings)(objectclass=department))", array("currenthome","guid"));
$info = ldap_get_entries($ds, $sr); $in = (isset($info[0]['currenthome'][0])) ? $info[0]['currenthome'][0] : NULL;
if ($in != NULL) {
	if ($in != $blank) {
		echo "InboundRecording Department - current home set\r\n";
		warning("InboundRecording Department - current home set");
	}
}

//Public (Internet) IP Address
//$sr = ldap_read($ds,"cn=Self,cn=Modules","objectclass=*"); $info = ldap_get_entries($ds,$sr); $self = $info[0]['location'][0];
//$sr = ldap_read($ds,"cn=1,cn={$self},cn=Modules","objectclass=administrationmodule"); $info = ldap_get_entries($ds,$sr); $publicIPAddress = $info[0]['publicipaddress'][0];
//if (strlen($publicIPAddress) >=1) {
//	if ($in != $blank) {
//		echo "Public (Internet) IP Address is set\r\n";
//		warning("Public (Internet) IP Address is set");
//	}
//}


if(substr(phpversion(),0,1)=="4") {
// DISK HEALTH
$a=$d=array();

// Find disk info.
$cmd= "/usr/sbin/smartctl -i /dev/hda";
exec($cmd,$d);

// Disks Array
$diskarray = array('WDC WD2500BPVT');
$pattern = implode("|",$diskarray);

if (preg_match("/($pattern)/", $d[4])){ // if in array

// run command to get raw disk output
$cmd = "/usr/sbin/smartctl -v 194,unknown -a /dev/hda";
exec($cmd,$a);

foreach($a as $k => $v) {
   if (strpos($v,"test result:")) if (!strpos($v,"PASSED")) warning ("DISK: $v");
   if (strpos($v,"o Errors Logged")==1) $noerrors=1;

   	//   ID#	ATTRIBUTE_NAME	FLAG	VALUE	WORST	THRESH	TYPE	UPDATED	WHEN_FAILED	RAW_VALUE
    sscanf($v,"%s %s %s %s %s %s %s %s %s %s", $id, $name, $flag, $value, $worst, $thresh, $type, $updated, $when, $raw);

   	if ($id=="194") {
	 $hex = dechex($raw); $parts = str_splity($hex, 2);$dt = hexdec($parts[2]); // convert $raw to HEX, Split into 3 blocks of 2, convert 3rd block to decimal
   	}

	if ($id=="194" and $dt>=60 ) warning (" Disk temperature $dt C");
	}

} else { // if not in array

// run command to get disk output
$cmd = "/usr/sbin/smartctl -a /dev/hda";
exec($cmd,$a);

foreach($a as $k => $v) {
   if (strpos($v,"test result:")) if (!strpos($v,"PASSED")) warning ("DISK: $v");
   if (strpos($v,"o Errors Logged")==1) $noerrors=1;

	//   ID#	ATTRIBUTE_NAME	FLAG	VALUE	WORST	THRESH	TYPE	UPDATED	WHEN_FAILED	RAW_VALUE
   	sscanf($v,"%s %s %s %s %s %s %s %s %s %s", $id, $name, $flag, $value, $worst, $thresh, $type, $updated, $when, $raw);
	if ($id=="194" and $raw>=60 ) warning (" Disk temperature $raw C");
	}
}

//enable smart if disabled
    if (strpos($v,"MART support is: Disabled")) {
      warning("DISK: $v");
      $smartoff =1;
    }

	if ($noerrors==0) warning ("DISK: SMART found Errors.");
	if ($smartoff){
    	$cmd = "/usr/sbin/smartctl -s on /dev/hda";
    	exec($cmd,$a);
	}

// telnet login attacks
$a=array();
$cmd = "grep 'FAILED LOGIN SESSION' /logs/syslog*";
exec($cmd,$a);
$count = count($a);
if ($count>9) warning("$count FAILED LOGIN SESSION(s) - from syslog* for telnet/ssh.");

} // PHP V4
ldap_close($ds);
//print "Done\n";

//PHP4 Functions
function str_splity($string, $split_length = 1) {
    $array = explode("\r\n", chunk_split($string, $split_length));
    array_pop($array);
    return $array;
}


function strpos_arr($haystack, $needle) {
    if(!is_array($needle)) $needle = array($needle);
    foreach($needle as $what) {
        if(($pos = strpos($haystack, $what))!==false) return $pos;
    }
    return false;
}
?>
