<?php
// FTP Backup 
// 2.4 15-JAN-2019 - updated include paths
// 2.3 28-DEC-2018 - added fullexcludearchive as backup option.
// 2.2 13-April-2018- nice 
// 2.1 16-July-2015 - Add backup filesize to output and logs
// 2.0 10-July-2015 - Change path used to create backups - CallServer uses /voicemail  S8000 uses /SpliceCom/Web/download/
// 1.9 06-July-2015 - Change Backup and FTP Connection order to help with time out on large systems.
// 1.7 24-Oct-2014 - moved to WebManager
// v1.6  - 24-09-2014 - added full backup option. Includes web.tar, voicemail.tar0, database
// v1.5 - 22-July-2014
// Backup file to be run from command line or Cron Job
// Creates database backup. File name is based on first 10 characters of the system name followed by -Backup date & time
// eg: Demonstrat-Backup-20.07.14-203820.txt
// optional logging can be enabled to /SpliceCom/Web/download/ftpbackup.log

$action = (isset($argv[1])) ? $argv[1] : NULL;
if ($action == 'full') {
	$full = "1";
} elseif ( $action == "fullexcludearchive") {	
	$full = "2";
} else {
	$full = NULL;
}


$ftp_host = "127.0.0.1"; 		// Remote FTP server
$ftp_user = "ftp_username"; 			// FTP username
$ftp_pass = "ftp_password"; 		// FTP password


$ftp_host = "x.x.x.x"; 		// Remote FTP server
$ftp_user = "user"; 			// FTP username
$ftp_pass = "password"; 		// FTP password


$manager = "Manager";			// Manager username
$managerpassword = "managerpassword";	// Manager password

$remove_backup = "1"; 		// 0 = Off 1 = On 	- delete tar.gz backup if upload is successful - CallServer path /voicemail/  S8000 path /SpliceCom/Web/download/
$logging = "1"; 		// 0 = Off 1 = On  	- log written to /SpliceCom/Web/download/ftpbackup.log
$warnings = "1";		// 0 = Off 1 = On	- write upload state to warnings
$logfile = "/SpliceCom/Web/download/ftpbackup.log";


/*************************************************************************
						nothing to change below
**************************************************************************/

if (isset($full) && $full >= "1") {
// check model
$cmd = "cat /proc/version";
exec($cmd,$a); $a = (count($a) >=1) ? $a[0] : "";
$model = (preg_match('~\b(suse|centos|red)\b~i',$a)) ? "S8000" : "CallServer";	

// check free space vs required space
if ($model == "CallServer") {	
	$available = (disk_free_space("/voicemail")/1024);
	$voicemail = explode("/",exec("du -s /voicemail/Mailbox"));
} else {
	$available = (disk_free_space("/")/1024);
	$voicemail = explode("/",exec("du -s /home/voicemail"));
}
$voicemail = trim($voicemail[0]);
	
$web = explode("/",exec("du -s /SpliceCom/Web"));
$web = trim($web[0]);

$required_space = ($voicemail + $web)*2.75;	
	
echo "Required Space $required_space\n";
echo "Available Space $available\n\n";

if ( $required_space > $available) { echo "Sorry insufficient disk space to proceed\n\n"; exit; }
}


include "/SpliceCom/WebManager/assist/tzone.php";
include "/SpliceCom/WebManager/assist/ftpclass.php";
$debug = FALSE;

// test ftp connection or die
$ftp = new ftp();
$ftp->debug = FALSE;

if (!$ftp->ftp_connect($ftp_host)) {
	die("Cannot connect\n");
}

if (!$ftp->ftp_login($ftp_user, $ftp_pass)) {
	$ftp->ftp_quit();
	die("Login failed\n\n");
} else {
	$ftp->ftp_quit();
	echo "FTP Connection OK\n\n";
}
// 

$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		exit ("LDAP connect failure<br>");
	} else {
		$r = ldap_bind($ds,$manager,$managerpassword);
		ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
	if ( ! $r) {
			$ds = false;
			exit ("LDAP bind failure<br>");
		}
	}

echo "Backing Up Database\n\n";
$sr = ldap_read($ds,"cn=System","objectclass=*"); $info = ldap_get_entries($ds,$sr);
$sysname=str_replace(' ','',(substr($info[0]['administrationdomain'][0],0,10))); $backup = $sysname."-Backup-".date('d.m.y-His');
$ent["dobackupto"] = "../ftp/$backup.txt"; ldap_modify($ds,"cn=Commands",$ent);

$fs = (filesize("/SpliceCom/Database.txt"));
sleep(ceil(($fs/(1024 * 1024))));

$local_filename  = "/SpliceCom/ftp/$backup.txt";
$remote_filename = $backup;

if ($full) 	{
	
	echo ($full == "1") ? "Performing Full Backup\nPlease wait this can take a while...\n" : "Performing Full Backup excluding Archive\nPlease wait this can take a while...\n";
	echo ($model=="CallServer") ? "Backup Path: /voicemail\n\n" : "Backup Path: /SpliceCom/Web/download/\n\n";
	
	
	
	if ($model == "CallServer") {
		$fullcmd = ($full == "2") ? "--exclude=Mailbox/Archive" : "";
		exec ("cd /voicemail; nice -10 tar $fullcmd -cvPf /voicemail/voicemail.tar0 M*;");
		echo "voicemail... done\n\n";
		exec ("cd /SpliceCom/Web; nice -10 tar --exclude=download -cvPf /SpliceCom/ftp/web.tar *;");
		echo "web... done\n\n";
		echo "Creating tar.gz file...\n";
		exec("nice -10 tar -cvzPf /voicemail/$backup.full.tar.gz /SpliceCom/ftp/web.tar /voicemail/voicemail.tar0 /ftp/$backup.txt",$output);	
		echo "done\n\n";
		$local_filename  = "/voicemail/$backup.full.tar.gz";
		unlink ("/voicemail/voicemail.tar0"); unlink ("/SpliceCom/ftp/web.tar");
	} else {
		$fullcmd = ($full == "2") ? "--exclude=voicemail/Archive" : "";
		exec ("cd /home; nice -10 tar $fullcmd -cvPf /SpliceCom/Web/download/voicemail.tar0 voice*;");
		echo "voicemail... done\n\n";
		exec ("cd /SpliceCom/Web; nice -10 tar --exclude=download -cvPf /SpliceCom/ftp/web.tar *;");
		echo "web... done\n\n";
		echo "Creating tar.gz file...\n";
		exec("nice -10 tar -cvzPf /SpliceCom/Web/download/$backup.full.tar.gz /SpliceCom/ftp/web.tar /SpliceCom/Web/download/voicemail.tar0 /SpliceCom/ftp/$backup.txt",$output);	
		echo "done\n\n";
		$local_filename  = "/SpliceCom/Web/download/$backup.full.tar.gz";
		unlink ("/SpliceCom/Web/download/voicemail.tar0"); unlink ("/SpliceCom/ftp/web.tar");
	}
	$remote_filename = "$backup.full.tar.gz";
	
} else {
	
	echo "gzip'ing Backup File\n\n";
	
	exec("cd /SpliceCom/ftp; nice -10 tar -cvzPf /SpliceCom/Web/download/$backup.tar.gz $backup.txt",$output);
	$local_filename  = "/SpliceCom/Web/download/$backup".".tar.gz";
	$remote_filename = "$backup.tar.gz";
}


// ftp connection
$ftp = new ftp();
$ftp->debug = $debug;

if (!$ftp->ftp_connect($ftp_host)) {
	die("Cannot connect\n");
}

if (!$ftp->ftp_login($ftp_user, $ftp_pass)) {
	$ftp->ftp_quit();
	die("Login failed\n");
}

if ($ftp->ftp_file_exists($remote_filename) == 1) {
	$ftp->ftp_quit();
	die($remote_filename." already exists\n");
}

echo "Uploading File\n";
$file_size = formatSizeUnits(filesize($local_filename));
echo "File Size to upload: $file_size\n\n";

if ($ftp->ftp_put($remote_filename, $local_filename)) {
	echo $local_filename." has been uploaded to $ftp_host as ".$remote_filename."\n\n";
	if (isset($remove_backup) && $remove_backup == "1") unlink ($local_filename);
	if (isset($logging) && $logging == "1") {
		$fh = fopen($logfile, 'a') or die("can't open log file - check permissions");
		$msg = $local_filename." has been uploaded to $ftp_host as ".$remote_filename." Filesize: $file_size\n";
		fwrite($fh, $msg); fclose($fh);
		if (isset($compress) && $compress == "1") unlink ($local_filename);
	}
	if (isset($warnings) && $warnings == "1") warning ("$local_filename has been uploaded to <b>$ftp_host</b> as $remote_filename Filesize: $file_size");

} else {
	$ftp->ftp_quit();
	if (isset($warnings) && $warnings == "1") warning ("$local_filename - Error!!");
	die("Error!!\n");
}

$ftp->ftp_quit();

function warning($s) {
	global $manager, $managerpassword; 
	$ds = ldap_connect("127.0.0.1",4000);
	if ( ! $ds) {
		exit ("LDAP connect failure<br>");
	} else {
		$r = ldap_bind($ds,$manager,$managerpassword);
		ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
	if ( ! $r) {
			$ds = false;
			exit ("LDAP bind failure<br>");
		}
	}
	$ent["doWarning"] = $s; ldap_modify($ds,"cn=Commands",$ent);
	ldap_close($ds);
}

function formatSizeUnits($bytes) {
        if ($bytes >= 1073741824)
        {
            $bytes = number_format($bytes / 1073741824, 2) . ' GB';
        }
        elseif ($bytes >= 1048576)
        {
            $bytes = number_format($bytes / 1048576, 2) . ' MB';
        }
        elseif ($bytes >= 1024)
        {
            $bytes = number_format($bytes / 1024, 2) . ' KB';
        }
        elseif ($bytes > 1)
        {
            $bytes = $bytes . ' bytes';
        }
        elseif ($bytes == 1)
        {
            $bytes = $bytes . ' byte';
        }
        else
        {
            $bytes = '0 bytes';
        }

        return $bytes;
}

?>