<?

//  GLOBALS

// enumeration arrays

$ModuleType 		= Array("","CallServer","TrunkModule","PhoneModule15","PhoneModule30",
				"IndependentCallServer","ExternalLDAPServerModule", "ExternalGatewayModule",
				"CompressorModule", PhoneModule8, RemoteCallServerModule
				);
$ModuleStatus 		= Array("Member","Available","NonMember");
$AdministrationMode 	= Array("","Primary","Secondary");  // bobg was here 8jul02
$DHCPMode 		= Array("","Enable","Disable","Client");
$RIPMode 		= Array("","RIPSendOnly","RIPEnable","RIPDisable");
$AuthenticationMethod	= Array("","AuthSimple","AuthKerbebosLDAP","AuthKerebosDSA");
$ExternalOperationMode 	= Array("","ContactsServer","UserServer","FullServer");
$VoicemailCapability 	= Array("","All","AutoAttendent","VoiceMail","Queue");
$OutOfOffice 		= Array("InTheOffice","InMeeting","AtLunch","OnHoliday","OffSite");
$RingTuneType 		= Array("","System","Internal","External","CallerID","Destination","Parallel");
$VoicemailContactType 	= Array("","Telephone","Email","SMS","Lamp","Archive","ArchiveEmail","SMSWeb");
$VoicemailContactMethod = Array("","Alert","Deliver","Copy","Access","Prompt","Deliver and Delete","Deliver New", "Deliver Link");
$OutOfHoursMode 	= Array("","Timed","OutOfHours","InHours");
$RecordMode 		= Array("","Resource","Mandatory","Random","Disable");
$DistributionMode 	= Array("","All","Rotary","Sequential","Manual");
$ForwardMode		= Array("None","Personal","DualPersonal","All","DualAll");
$TypeOfPhone 		= Array("","POTS","PCS","GenericIPPhone");
$CallerDisplayType 	= Array("None","Default","BT","Bell","DTMF","BTNoMessages","TrunkLine","FaxServer","Interquartz","AlarmPort","PCS","PCSLamp","Lamp","PayPhone");
$SplicePhoneModel 	= Array("","Mono480_320","Colour480_320","Colour640_480");
$IPPhoneModel 		= Array("","IPStandard");
$TypeOfTrunk 		= Array("ETSI_PRI","ETSI_BRI","EXTERNAL");
$ISDNMode			= Array("ETSI", "DPNSS.1", "NZ PRA Lite");
$ISDNChannelAllocationMode = Array("Default", "TopDown", "BottomUp");
$BearerCapability 	= Array("","Voice","Data","Video","Fax");
$DialAction 		= Array("None","Dial","Busy","NumberUnavailable","Page",
			        "DialEmergency","DialAutoAnswer","DialForceCallWaiting",
				"OutOfOfficeEnable","OutOfOfficeDisable","ForwardOnBusyEnable",
				"ForwardOnBusyDisable","ForwardOnBusyToggle","ForwardOnBusySet",
				"ForwardOnNoAnswerEnable","ForwardOnNoAnswerDisable","ForwardOnNoAnswerToggle",
				"ForwardOnNoAnswerSet","FollowMeEnable","FollowMeDisable","FollowMeToggle",
				"FollowMeSet","CancelAllForwarding","DoNotDisturbEnable","DoNotDisturbDisable",
				"DoNotDisturbToggle","DoNotDisturbExceptionAdd","DoNotDisturbExceptionRemove",
				"DoNotDisturbExceptionRemoveAll","CallWaitingEnable","CallWaitingDisable",
				"CallWaitingPhoneTools","VoicemailEnable","VoicemailDisable","VoicemailRetrieve",
				"VoicemailAddCallMe","VoicemailRemoveCallMe","VoicemailRemoveAllCallMe","NightServiceInHours",
				"NightServiceOutOfHours","NightServiceTimed","CampOn","Park","Pickup","Login","Logout",
				"RelayOpen","RelayPulse","RelayClose","SetEvent","DialTrunk", "SetMobileNumber", "SetHomeNumber", "SetSpare1Number","SetSpare2Number",
		                "FollowMeAll", "FollowMeDualPersonal", "FollowMeDualAll","DialRecall","DialAccount","DialAutoConference",
				"DialRecord","DialPriority","DialHash","DialTransparent","DialAutoListen","Conference","VoicemailGreeting","VoicemailGreetingPermanent",
                                "DialForceCWRecall"
				);


$AutoURL 		= Array("NoAction","OnRing","OnConnect","Favorites","Users","Departments");
$DirAutoURL     = Array("Bothway","Incoming","Outgoing");
$AutoAttendantAction 	= Array("None","Transfer","Goto","SubMenu","PlayWav","DialInternal","Hangup","OverlapDial","CollectDigits","EmailResults");

$UserClass 		= Array("Normal","Restricted","HotelRoom");
$UserDisplayPref 	= Array("Normal","Small","Large" );

$ScreenSaverMode = Array("None","Idle","Night");
$NatMode = Array("None","Static","STUN");

$DayOfWeek		= Array("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday");
$MonthOfYear	= Array("","Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");
$DayOfMonth		= Array("","1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19","20","21","22","23","24","25","26","27","28","29","30","31");
$CallWaiting		= Array("Disable","Enable","PhoneTools","NoBeep");
$PPPAuthProt		= Array("Pap","Chap");
$PPPAuthMethod		= Array("Incoming","Outgoing","Bothway");
$PPPSeqNums		= Array("Short (2 bytes)","Long (4 bytes)");
$VoiceCompressionType	= Array("None","ALAW64K","","","","","","","","","","G729A8K","Relay");
$PagingPortType = Array("None","Paging","MusicOnHold");
$OutgoingCallingPartyPlan = Array("Unknown","International","National");
$CallDebugLevel 		= Array("Basic","Normal","Detail","Debug");



// object arrays

$SystemArray				= 
	Array("cn","administrationDomain","description","locale","callLoggingPassword","diagnosticEngineeringPassword","supplier","webPassword","maintainerPassword");
$AdministratorArray			=
	Array("cn","description","userPassword","");
$LicenseArray			=
	Array("key","qty","license","");
$accessRightArray			=
	Array("permission","","","");

$ModuleArray			       	=
	Array("cn","description","moduleType","locale","serialNumber","moduleStatus","ipAddress","productVersion","location");
$AdministrationModuleArray		=
	Array("cn","administrationMode","cachingPeriod","dhcpServerMode","dhcpStartAddress","dhcpEndAddress",dnsDomain,
    	      "dnsPrimary","dnsSecondary","ripMode","publicIPAddress","publicIPMask","publicFirewall","autoAddPhones");
$TrunkModuleArray			=
	Array("cn","","","");
$IndependentAdministrationModuleArray	= 
	Array("cn","administrator","userPassword","Domain");
$ExternalLDAPModuleArray		=
	Array("cn","administrator","userPassword","authenticationMethod","operationMode","root");
$ExternalGatewayModuleArray		=
	Array("cn","","","");

$VoicemailPortArray		       	=
	Array("cn","description","location","H323Address","capabilityAA","capabilityVM","capabilityMusic","capabilityQueue","capacity","productVersion","emailSmartHost","emailSourceAddress","dialPlan");

$CompanyArray				=
	Array("cn","description","","");

$UserArray				=
	Array("cn","description","telephoneNumber","locale","initialPhone","voicemailEnabled","messageBoxLicense","voicemailAccessCode",
    	      "voicemailAssistantTelephoneNumber","dialPlan","callWaiting","doNotDisturb","outgoingCallBar",
    	      "exDirectory","requireAccountCoding","noAnswerTime","followMe","followMeTo","forwardOnBusy",
    	      "forwardOnBusyTo","forwardOnNoAnswer","forwardOnNoAnswerTo","loginAccessCode","loginIdleTime","supervisorOf",
    	      "outOfOffice","outOfOfficeMsg","homeTelephoneNumber","mobileTelephoneNumber","spare1TelephoneNumber",
    	      "spare2TelephoneNumber","homePage","currentHome","company");
$CapabilityArray			=
	Array("capability","capabilityPercent","","");
$RingTuneArray				=
	Array("type","telephoneNumber","tune","");
$VoicemailContactArray			=
	Array("type","method","telephoneNumber","");
$DNDExceptionArray			=
	Array("telephoneNumber","","","");
$SpeedDialArray				=
	Array("description","shortCode","telephoneNumber","");
        
$DepartmentArray			=
	Array("cn","description","telephoneNumber","maxRingBeforeAnnouncementTime","repeatAnnouncmentTime",
    	      "maxRingBeforeAlternateDistributionTime","maxNumberOfActiveCallsBeforeBusy","wrapUpTime",
    	      "timePlan","outOfHoursMode","voicemailEnabled","messageBoxLicense","voicemailAccessCode","voicemailAssistantTelephoneNumber",
    	      "recordRate","recordMode","recordGroup","distributionGroup","distributionMode","alternateDistributionGroup",
    	      "alternateDistributionMode","outOfHoursDistributionGroup","outOfHoursDistributionMode","noAnswerTime",
    	      "maxNoAnswerTimeBeforeVoicemail","maxNoAnswerTimeBeforeVoicemailOOH","alternateDistributionGroup2","alternateDistributionMode2",
	      "URL","autoURL",currentHome);	      

$GroupArray			       	=
	Array("cn","description","","");
$MemberArray				=
	Array("member","","","");

$UnassignedPhoneArray				=
	Array("serialNumber","typeOfPhone","cn","status","location");

$PhoneArray				=
	Array("cn","description","typeOfPhone","location","productVersion");
$POTSPhoneArray				=
	Array("cn","callerDisplayType","pagingPort","callerDisplayLen","remotePSTN","partnerLoginCode","offHookWorking");
$SplicePhoneArray			=
	Array("cn","model","serialNumber","partnerLoginCode");
$GenericIPPhoneArray			=
	Array("cn","model","","");

$TrunkArray			       	=
	Array("cn","description","presentationNumber","typeOfTrunk","ddiCallPlan","capacity","reserveIncomingCapacity",
    	      "reserveVoiceCapacity","reserveDataCapacity","port","outOfService");
$ETSITrunkArray				=
	Array("cn","tei","nt","");

$WANLinkArray				=
	Array("cn","description","accountNameOut","accountPasswordOut","accountNameIn","accountPasswordIn",
    	      "wanPort","telephoneNumber","VPNAddress","ripMode","voiceMaxCapacity","timePlan",
              "dialUsageQuota","NATFirewall","ddiTelephoneNumber");

$IntranetConnectionArray		=
	Array("cn","userPassword","description","telephoneNumber","remoteCN","remoteUserPassword","remoteTelephoneNumber",
    	      "ripMode","voiceMaxCapacity");
$WANPortRefArray			=
	Array("WANPort","","","");
$WANPortArray			=
	Array("cn","description","speed","");
$PPPParamsArray				=
	Array("cn","MLCP","","");
$CallerIDArray				=
	Array("telephoneNumber","","","");
$BODParamsArray			       	=
	Array("cn","minCallTime","noSessionIdlePeriod","activeSessionIdlePeriod","idleTrafficCheck","minChannelsRequired",
    	      "maxChannelsAllowed","extraBandwidthThreshold","reduceBandwidthThreshold");

$InternetConnectionArray		=
	Array("cn","description","accountName","userPassword","telephoneNumber","timePlan","dialUsageQuota","firewall");

$IPRouteArray				=
	Array("ipAddress","ipMask","gateway","metric","interface","location");

$DDICallPlanArray			=
	Array("cn","description","","");
$DDIEntryArray				=
	Array("numberMatch","bc","callerID","timePlan","translateTo","locale");

$TrunkGroupArray			=
	Array("cn","description","","");
$TrunkRefArray			       	=
	Array("trunk","","","");

$LeastCostCallPlanArray			=
	Array("cn","description","location","");
$LCREntryArray				=
	Array("numberMatch","timePlan","dialPrimary","dtmfPrimary","trunkGroupPrimary","actionPrimary",
    	      "dialSecondary","dtmfSecondary","trunkGroupSecondary","actionSecondary");

$DialPlanArray				=
	Array("cn","description","dialDelayTime","dialDelayCount");
$DPEntryArray			       	=
	Array("numberMatch","timePlan","translateTo","action","translateCLITo");

$TimePlanArray				=
	Array("cn","description","","");
$TimeBandArray				=
	Array("startDayofWeek","startTime","endDayofWeek","endTime");

$FirewallArray				=
	Array("cn","description",
    	      "natEnabled","incommingSMTPIPAddress","incommingDefaultIPAddress","ftpMode","telnetMode","smtpMode",
    	      "pop3Mode","timeMode","dnsMode","httpMode","ircMode","pptpMode","igmpMode","h323Mode","rsvpMode",
    	      "gopherMode","fingerMode","snmpMode","newsMode");

$ContactArray				=
	Array("cn","description","telephoneNumber","facsimileTelephoneNumber","homeTelephoneNumber","mobileTelephoneNumber",
    	      "spare1TelephoneNumber","spare2TelephoneNumber","ambiguousTelephoneNumber",
    	      "o","ou","title","sn","street","l","st","postalCode","c","ourAccount","theirAccount","mail","URL","autoURL",
	      directRouteTo);
$NoteArray				=
	Array("dateTime","originator","comment","");

$AreaCodeArray				=
	Array("cn","ambiguousTelephoneNumber","","");

$MusicChannelArray				=
	Array("cn","playlist","multicastAddress","multicastPort");

$AutoAttendantKeyArray				=
	Array("cn","telephoneNumber","","");

$ExAutoAttendantKeyArray				=
	Array("cn","telephoneNumber","action","");

$ExtendedAttendantArray				=
	Array("cn","","","");

$EventArray				=
	Array("cn","userGroup","phoneGroup","URL");

$MeetMeConferenceArray			=
	Array("cn","organiser","startTime","endTime","date","pin","maxMembers","secure");


$AccessRightArray			=
	Array("location","class","readAllowed","writeAllowed","createAllowed","deleteAllowed");



$stringarray = Array();
$stringarray["System"] = "System";
$stringarray["Administrators"] = "Administrators";



// session related globals

$GLOBALS[pnarray]   = Array();
$GLOBALS[dearray]   = Array();
$GLOBALS[rdearray]  = Array();
$GLOBALS[ndearray]  = Array();
$GLOBALS[ddearray]  = Array();

$GLOBALS[guarray]   = Array();
$GLOBALS[dguarray]  = Array();
$GLOBALS[sguarray]  = Array();

$GLOBALS[coarray]   = Array();
$GLOBALS[dcoarray]  = Array();

$GLOBALS[clarray]   = Array();
$GLOBALS[dclarray]  = Array();
$GLOBALS[uclarray]  = Array();

$GLOBALS[paarray]   = Array();

$GLOBALS[actarray]  = Array();
$GLOBALS[naarray]   = Array();
$GLOBALS[lnaarray]  = Array();
$GLOBALS[attarray]  = Array();

$GLOBALS[dirarray]  = Array();
$GLOBALS[indarray]  = Array();



// general globals

$GLOBALS[thispagename] = "";
$GLOBALS[thisdepth] = "";
$GLOBALS[thisretdepth] = "";
$GLOBALS[thisnxtdepth] = "";
$GLOBALS[thisdisplaydepth] = "";

$GLOBALS[thisguid] = "";
$GLOBALS[thisdisplayguid] = "";
//$GLOBALS[thisselectguid] = "";
$GLOBALS[thisselectguid] = 0;


$GLOBALS[thiscont] = "";
$GLOBALS[thisdisplaycont] = "";

$GLOBALS[thisclassname] = "";
$GLOBALS[thisdisplayclassname] = "";
$GLOBALS[thisupperclassname] = "";

$GLOBALS[thisparent] = "";

$GLOBALS[thisaction] = "";
$GLOBALS[thisname] = "";
$GLOBALS[thislistname] = "";
$GLOBALS[thisattribute] = "";

$GLOBALS[thisdirection] = "";
$GLOBALS[thisindex] = "0";
$GLOBALS[thistab] = "0";  // the default (first) tab


$GLOBALS[guiddn] = "";
$GLOBALS[cndn] = "";
$GLOBALS[mgrresult] = "";
$GLOBALS[attrprefix] = "";
$GLOBALS[attrpostfix] = "";
$GLOBALS[currentguid] = "";
$GLOBALS[currentobjclass] = "";
$GLOBALS[addpage] = "";
$GLOBALS[modpage] = "";
$GLOBALS[actionok] = "";
$GLOBALS[addguid] = "";

$GLOBALS[atsubobject] = -1;  // index into subguid array
$GLOBALS[subguid] = Array();

$GLOBALS[attrnum] = 0;
$GLOBALS[tattrs] = "";
$GLOBALS[tvals] = "";
$GLOBALS[aattrs] = Array();
$GLOBALS[avals] = Array();

$GLOBALS[ldepth] = "";  // last depth (from)
$GLOBALS[cdepth] = "";	 // current depth (here)
$GLOBALS[ndepth] = "";	 // next depth (to)
$GLOBALS[rdepth] = "";	 // return depth (back)

$GLOBALS[httpdmgr] = "";
$GLOBALS[ldapresult] = "";
$GLOBALS[ldapinfo] = "";

// list processing globals

$GLOBALS[displayphonetype] = "";

$GLOBALS[nameind] = "";
$GLOBALS[nents] = "";
$GLOBALS[prevpos] = "";
$GLOBALS[nextname] = "";
$GLOBALS[prevname] = "";

$GLOBALS[pageextension] = "";


$GLOBALS[resn] = Array();
$GLOBALS[resg] = Array();
$GLOBALS[respext] = Array();
$GLOBALS[display1] = Array();
$GLOBALS[display2] = Array();
$GLOBALS[display3] = Array();
$GLOBALS[listnames] = Array();
$GLOBALS[listguids] = Array();
$GLOBALS[listpexts] = Array();
$GLOBALS[listdisplay1] = Array();
$GLOBALS[listdisplay2] = Array();
$GLOBALS[listdisplay3] = Array();

// some GUID functions... may change in time

function AGuid($guidstr)
{	// this is the way a guid is defined (may change way of detecting it)

    if((strlen($guidstr) == 36) &&
		(substr($guidstr,8,1) == '-') &&
		(substr($guidstr,13,1) == '-') &&
		(substr($guidstr,18,1) == '-') &&
		(substr($guidstr,23,1) == '-'))
	{
		return true;
	}
	return false;
}

function ANullGuid($guidstr)
{
	if (!AGuid($guidstr))
	{
		return true;  // not a GUID so treat as NULL
	}
	if ($guidstr == "00000000-0000-0000-0000-000000000000")
	{
		return true;  // actually NULL
	}
	if ($guidstr == "deadbeef-dead-beaf-dead-beefdeadbeef")
	{
		return true;  // possibly NULL
	}

	return false;  // not NULL
}

function GetZeroGuid()
{
	return "00000000-0000-0000-0000-000000000000";
}

function GetNullGuid()
{
	return "deadbeef-dead-beaf-dead-beefdeadbeef";
}


// initialise globals and other set/get functions

function SessionRegister()
{
	include "global.inc";

	if (!session_is_registered("Depth"))
	{	// set all session vars here

		session_register("Depth");
		$Depth = 0;
        session_register("InitTab");
		$InitTab = 0;
        session_register("PageCount");
        $PageCount = 0;
        session_register("TopOfList");
        $TopOfList = "";
        session_register("BottomOfList");
        $BottomOfList = "";        
        session_register("ParentTopOfLIst");
        $ParentTopOgList = "";        
        session_register("ParentBottomOfList");
        $ParentBottomOfList = "";        
		session_register("ErrorReport");
		$ErrorReport = "";
		session_register("ListForward");
		$ListForward = Array();
		session_register("ListBack");
		$ListBack = 0;

		session_register("PNArray");
		$PNArray = Array();
		session_register("DEArray");
		$DEArray = Array();
		session_register("RDEArray");
		$RDEArray = Array();
		session_register("NDEArray");
		$NDEArray = Array();
		session_register("DDEArray");
		$DDEArray = Array();

		session_register("GUArray");
		$GUArray = Array();
		session_register("DGUArray");
		$DGUArray = Array();
		session_register("SGUArray");
		$SGUArray = Array();

		session_register("COArray");
		$COArray = Array();
		session_register("DCOArray");
		$DCOArray = Array();

		session_register("CLArray");
		$CLArray = Array();
		session_register("DCLArray");
		$DCLArray = Array();
		session_register("UCLArray");
		$UCLArray = Array();

		session_register("PAArray");
		$PAArray = Array();

		session_register("ACTArray");
		$ACTArray = Array();
		session_register("NAArray");
		$NAArray = Array();
		session_register("LNAArray");
		$LNAArray = Array();
		session_register("ATTArray");
		$ATTArray = Array();

		session_register("DIRArray");
		$DIRArray = Array();
		session_register("INDArray");
		$INDArray = Array();
	}
}

function InitialiseGlobals()
{

	$GLOBALS[guiddn] = "";
	$GLOBALS[cndn] = "";
	$GLOBALS[mgrresult] = "";
	$GLOBALS[attrprefix] = "";
	$GLOBALS[attrpostfix] = "";
	$GLOBALS[addpage] = "";
	$GLOBALS[modpage] = "";
	$GLOBALS[actionok] = 0;
	$GLOBALS[ldepth] = 0;
	$GLOBALS[cdepth] = 0;
	$GLOBALS[ndepth] = 0;
	$GLOBALS[rdepth] = 0;


    $_SESSION[PageCount]++;
	$_SESSION[ListBack]++;
	$GLOBALS[thisselectguid] = $_SESSION[ListBack];

	if (count($_SESSION[ListForward]) != 0)
	{
		$_GET = $_SESSION[ListForward];
		$blanka = Array();
		$_SESSION[ListForward] = $blanka;
	}

	if (array_key_exists("de",$_GET))
	{
		$GLOBALS[thisdepth] = $_GET["de"];
	}
	if (array_key_exists("rde",$_GET))
	{
		$GLOBALS[thisretdepth] = $_GET["rde"];
	}
	if (array_key_exists("nde",$_GET))
	{
		$GLOBALS[thisnxtdepth] = $_GET["nde"];
	}
	if (array_key_exists("dde",$_GET))
	{
		$GLOBALS[thisdisplaydepth] = $_GET["dde"];
	}

	if (array_key_exists("gu",$_GET))
		$GLOBALS[thisguid] = $_GET["gu"];
	if (array_key_exists("dgu",$_GET))
		$GLOBALS[thisdisplayguid] = $_GET["dgu"];
//	if (array_key_exists("sgu",$_GET))
//    {
//		$GLOBALS[thisselectguid] = $_GET["sgu"];
//    }

	if (array_key_exists("co",$_GET))
		$GLOBALS[thiscont] = $_GET["co"];
	if (array_key_exists("dco",$_GET))
		$GLOBALS[thisdisplaycont] = $_GET["dco"];

	if (array_key_exists("cl",$_GET))
		$GLOBALS[thisclassname] = $_GET["cl"];
	if (array_key_exists("dcl",$_GET))
		$GLOBALS[thisdisplayclassname] = $_GET["dcl"];
	if (array_key_exists("ucl",$_GET))
		$GLOBALS[thisupperclassname] = $_GET["ucl"];

	if (array_key_exists("pa",$_GET))
		$GLOBALS[thisparent] = $_GET["pa"];

	if (array_key_exists("act",$_GET))
		$GLOBALS[thisaction] = $_GET["act"];
	if (array_key_exists("na",$_GET))
		$GLOBALS[thisname] = $_GET["na"];
	if (array_key_exists("lna",$_GET))
		$GLOBALS[thislistname] = $_GET["lna"];
	if (array_key_exists("att",$_GET))
		$GLOBALS[thisattribute] = $_GET["att"];

	if (array_key_exists("dir",$_GET))
		$GLOBALS[thisdirection] = $_GET["dir"];
    
    if (($GLOBALS[thisupperclassname] != "") && ($GLOBALS[thisparent] == ""))
    {
        if (array_key_exists("ind",$_GET))
        {
            $GLOBALS[thisindex] = $_GET["ind"];
            $_SESSION[ParentTopOfList] = $GLOBALS[thisindex];
        }
        else
        {
            if ($GLOBALS[thisdirection] == "back")
            {
                $GLOBALS[thisindex] = $_SESSION[ParentTopOfList];
            }
            else if ($GLOBALS[thisdirection] == "forward")
            {
                $GLOBALS[thisindex] = $_SESSION[ParentBottomOfList];
            }
            else
            {
                $GLOBALS[thisindex] = $_SESSION[ParentTopOfList];            
            }
            
        }
    }
    else
    {
        if (array_key_exists("ind",$_GET))
        {
            $GLOBALS[thisindex] = $_GET["ind"];
            $_SESSION[TopOfList] = $GLOBALS[thisindex];
        }
        else
        {
            if ($GLOBALS[thisdirection] == "back")
            {
                $GLOBALS[thisindex] = $_SESSION[TopOfList];
            }
            else if ($GLOBALS[thisdirection] == "forward")
            {
                $GLOBALS[thisindex] = $_SESSION[BottomOfList];
            }
            else
            {
                $GLOBALS[thisindex] = $_SESSION[TopOfList];            
            }
            
        }
    }


	if ($GLOBALS[thisindex] == "")
		$GLOBALS[thisindex] = 0;


    if ($_SESSION[InitTab] > 0)
    {
        $GLOBALS[thistab] = $_SESSION[InitTab];
        $_SESSION[InitTab] = 0;
    }
	else if (array_key_exists("tab",$_GET))
	{
		$GLOBALS[thistab] = $_GET["tab"];
		if ($GLOBALS[thistab] == "")
		{
			$GLOBALS[thistab] = "0";
		}
	}
	else if (array_key_exists("itab",$_GET))
	{
		$GLOBALS[thistab] = $_GET["itab"];
		if ($GLOBALS[thistab] == "")
		{
			$GLOBALS[thistab] = "0";
		}
	}


    	if (array_key_exists("pn",$_GET))
	{
    		$GLOBALS[thispagename]=$_GET["pn"];
		$GLOBALS[thispagename] = strtolower($GLOBALS[thispagename]);
	}

	$len = strlen($GLOBALS[thispagename]);
	$normpagename = $GLOBALS[thispagename];
	if (substr($GLOBALS[thispagename],0,3) == "add")
	{	// normalise
		$normpagename = substr($GLOBALS[thispagename],3,$len-3);
	}
	$GLOBALS[addpage] = "add".$normpagename;
	$GLOBALS[modpage] = $normpagename;
	
	$GLOBALS[ldepth] = $GLOBALS[thisdepth];
	$GLOBALS[cdepth] = $GLOBALS[thisnxtdepth];
	$GLOBALS[rdepth] = $GLOBALS[thisretdepth];
	$GLOBALS[ndepth] = $GLOBALS[cdepth]+1;
	if ($GLOBALS[ldepth] > $GLOBALS[cdepth])
	{	// we are going backwards (maybe as a result of OK)
		// retrieve context
		GetSessionContextArrays();
		GetLocalContextArrays($GLOBALS[cdepth]);
		
		if (substr($GLOBALS[thispagename],0,3) == "add")
		{	// normalise
			$normpagename = substr($GLOBALS[thispagename],3,$len-3);
		}
		
		$GLOBALS[addpage] = "add".$normpagename;
		$GLOBALS[modpage] = $normpagename;
		$GLOBALS[ldepth] = $GLOBALS[thisdepth];
		$GLOBALS[cdepth] = $GLOBALS[thisnxtdepth];
		$GLOBALS[rdepth] = $GLOBALS[thisretdepth];
		$GLOBALS[ndepth] = $GLOBALS[cdepth]+1;
	} 
	else
	{
		SetLocalContextArrays($GLOBALS[cdepth]);
		SetSessionContextArrays();
	}

	$_SESSION[Depth] = $GLOBALS[cdepth];
    
//    $_SESSION[InitTab] = $GLOBALS[thistab];

};


function SetSessionContextArrays()
{

	$_SESSION[PNArray] 	= $GLOBALS[pnarray];  
	$_SESSION[DEArray] 	= $GLOBALS[dearray];  
	$_SESSION[RDEArray]	= $GLOBALS[rdearray];  
	$_SESSION[NDEArray]	= $GLOBALS[ndearray];  
	$_SESSION[DDEArray]	= $GLOBALS[ddearray];  
	       				          
	$_SESSION[GUArray] 	= $GLOBALS[guarray];  
	$_SESSION[DGUArray]	= $GLOBALS[dguarray];  
	$_SESSION[SGUArray]	= $GLOBALS[sguarray];  
	       				          
	$_SESSION[COArray] 	= $GLOBALS[coarray];  
	$_SESSION[DCOArray]	= $GLOBALS[dcoarray];  
	       				          
	$_SESSION[CLArray] 	= $GLOBALS[clarray];  
	$_SESSION[DCLArray]	= $GLOBALS[dclarray];  
	$_SESSION[UCLArray]	= $GLOBALS[uclarray];  
	       				          
	$_SESSION[PAArray] 	= $GLOBALS[paarray];  
	       				          
	$_SESSION[ACTArray]	= $GLOBALS[actarray];  
	$_SESSION[NAArray] 	= $GLOBALS[naarray];  
	$_SESSION[LNAArray]	= $GLOBALS[lnaarray];  
	$_SESSION[ATTArray]	= $GLOBALS[attarray];  
	       				          
	$_SESSION[DIRArray]	= $GLOBALS[dirarray];  
	$_SESSION[INDArray]	= $GLOBALS[indarray];
	
};

function GetSessionContextArrays()
{

	$GLOBALS[pnarray]  = $_SESSION[PNArray];
	$GLOBALS[dearray]  = $_SESSION[DEArray];
	$GLOBALS[rdearray] = $_SESSION[RDEArray];
	$GLOBALS[ndearray] = $_SESSION[NDEArray];
	$GLOBALS[ddearray] = $_SESSION[DDEArray];
	         
	$GLOBALS[guarray]  = $_SESSION[GUArray];
	$GLOBALS[dguarray] = $_SESSION[DGUArray];
	$GLOBALS[sguarray] = $_SESSION[SGUArray];
	         
	$GLOBALS[coarray]  = $_SESSION[COArray];
	$GLOBALS[dcoarray] = $_SESSION[DCOArray];
	         
	$GLOBALS[clarray]  = $_SESSION[CLArray];
	$GLOBALS[dclarray] = $_SESSION[DCLArray];
	$GLOBALS[uclarray] = $_SESSION[UCLArray];
	         
	$GLOBALS[paarray]  = $_SESSION[PAArray];
	         
	$GLOBALS[actarray] = $_SESSION[ACTArray];
	$GLOBALS[naarray]  = $_SESSION[NAArray];
	$GLOBALS[lnaarray] = $_SESSION[LNAArray];
	$GLOBALS[attarray] = $_SESSION[ATTArray];
	         
	$GLOBALS[dirarray] = $_SESSION[DIRArray];
	$GLOBALS[indarray] = $_SESSION[INDArray];


};

function SetLocalContextArrays($ind)
{

	GetSessionContextArrays();  // must get first to facilitate update

	$GLOBALS[pnarray][$ind] 	= $GLOBALS[thispagename];
	$GLOBALS[dearray][$ind]		= $GLOBALS[thisdepth];
	$GLOBALS[rdearray][$ind]	= $GLOBALS[thisretdepth];
	$GLOBALS[ndearray][$ind]	= $GLOBALS[thisnxtdepth];
	$GLOBALS[ddearray][$ind]	= $GLOBALS[thisdisplaydepth];
	                  
	$GLOBALS[guarray][$ind]		= $GLOBALS[thisguid];
	$GLOBALS[dguarray][$ind]	= $GLOBALS[thisdisplayguid];
    
//	$GLOBALS[sguarray][$ind]	= $GLOBALS[thisselectguid];
    
	                  
	$GLOBALS[coarray][$ind]		= $GLOBALS[thiscont];
	$GLOBALS[dcoarray][$ind]	= $GLOBALS[thisdisplaycont];
	                  
	$GLOBALS[clarray][$ind]		= $GLOBALS[thisclassname];
	$GLOBALS[dclarray][$ind]	= $GLOBALS[thisdisplayclassname];
	$GLOBALS[uclarray][$ind]	= $GLOBALS[thisupperclassname];
	                  
	$GLOBALS[paarray][$ind]		= $GLOBALS[thisparent];
	                  
	$GLOBALS[actarray][$ind]	= $GLOBALS[thisaction];
	$GLOBALS[naarray][$ind]		= $GLOBALS[thisname];
	$GLOBALS[lnaarray][$ind]	= $GLOBALS[thislistname];
	$GLOBALS[attarray][$ind]	= $GLOBALS[thisattribute];
	                  
	$GLOBALS[dirarray][$ind]	= $GLOBALS[thisdirection];
	$GLOBALS[indarray][$ind]	= $GLOBALS[thisindex];

};

function GetLocalContextArrays($ind)
{


	$GLOBALS[thispagename]         = $GLOBALS[pnarray][$ind]; 	
	$GLOBALS[thisdepth]            = $GLOBALS[dearray][$ind];	
	$GLOBALS[thisretdepth]         = $GLOBALS[rdearray][$ind];	
	$GLOBALS[thisnxtdepth]         = $GLOBALS[ndearray][$ind];	
	$GLOBALS[thisdisplaydepth]     = $GLOBALS[ddearray][$ind];	
	                                    
	$GLOBALS[thisguid]             = $GLOBALS[guarray][$ind];	
	$GLOBALS[thisdisplayguid]      = $GLOBALS[dguarray][$ind];	
//	$GLOBALS[thisselectguid]       = $GLOBALS[sguarray][$ind];	
    
    
	                                    
	$GLOBALS[thiscont]             = $GLOBALS[coarray][$ind];	
	$GLOBALS[thisdisplaycont]      = $GLOBALS[dcoarray][$ind];	
	                                    
	$GLOBALS[thisclassname]        = $GLOBALS[clarray][$ind];	
	$GLOBALS[thisdisplayclassname] = $GLOBALS[dclarray][$ind];	
	$GLOBALS[thisupperclassname]   = $GLOBALS[uclarray][$ind];	
	                                    
	$GLOBALS[thisparent]           = $GLOBALS[paarray][$ind];	
	                                    
	$GLOBALS[thisaction]           = $GLOBALS[actarray][$ind];	
	$GLOBALS[thisname]             = $GLOBALS[naarray][$ind];	
	$GLOBALS[thislistname]         = $GLOBALS[lnaarray][$ind];	
	$GLOBALS[thisattribute]        = $GLOBALS[attarray][$ind];	
	                                    
	$GLOBALS[thisdirection]        = $GLOBALS[dirarray][$ind];	
	$GLOBALS[thisindex]            = $GLOBALS[indarray][$ind];	
    
                                    
};


// general error processing

function ErrorAction($erraction,$errstring,$p1,$p2,$p3,$p4,$p5)
{

	global $mgrresult;
		
	if ($errstring != "")
	{
		$errmsg = $erraction.": ".$errstring;
		$mgrresult = $errmsg." P1= ".$p1." P2= ".$p2." P3= ".$p3." P4= ".$p4." P5= ".$p5;
		$_SESSION[ErrorReport] = $_SESSION[ErrorReport]."\r\n".$mgrresult;
	}
};


// functions that call ActiveX or ldap_* fns

function XSearchFor($p1,$p2,$p3,$p4)
{

	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;
	global $mgrresult;

	// $p1 is dn
	// $p2 is scope
	// $p3 is filter
	// $p4 is attributes

	$filt = $p3;
	if ($filt == "")
	{
		$filt = "(objectclass=*)";
	}

	if ($mgrresult == "")
	{
		if ($p2 == 0)
		{
			$ldapresult = @ldap_read($httpdmgr,$p1,$filt);
		}
		else if ($p2 == 1)
		{
			$ldapresult = @ldap_list($httpdmgr,$p1,$filt);
		}
		else
		{
			$ldapresult = @ldap_search($httpdmgr,$p1,$filt);
		}
	 	if (!$ldapresult)
	 	{	// some error
	 		$errno = ldap_errno($httpdmgr);
	 		$mgrresult = ldap_err2str($errno);
	 		ErrorAction("Search",$mgrresult,$p1,$p2,$filt,$p4,"");
	 	}
		else
		{
			$ldapinfo = ldap_get_entries($httpdmgr, $ldapresult); 
		}

	}
}


function XInitialise()
{

	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;
	global $mgrresult;
	global $thisclassname;
	global $thisguid;
	global $guiddn;

//	@session_start();

	SessionRegister();
	InitialiseGlobals();

	$httpdmgr=ldap_connect("127.0.0.1",4000);  // must be a valid LDAP server!
	if ($httpdmgr)
	{

		ldap_set_option($httpdmgr, LDAP_OPT_PROTOCOL_VERSION, 3);  // to fool ldap into allowing rename
    		//$r=ldap_bind($httpdmgr,"INTERNAL","001122334455");     // this is an "anonymous" bind, typically
    		$r=ldap_bind($httpdmgr,$_SERVER['PHP_AUTH_USER'],$_SERVER['PHP_AUTH_PW']);
	}
	else
	{
	        echo "LDAP CONNECT FAILURE"."<br>";
		$mgrresult = "LDAP CONNECT FAILURE";
		ErrorAction("LDAP",$mgrresult,"","","","","");
		return;
	}


	if ($thisclassname == "System")
	{
      		XSearchFor("",2,"(objectclass=System)","");

		$thisguid =$ldapinfo[0]["guid"][0];

		$guiddn = "GUID=".$thisguid;


	}
	else if ($thisguid != "" && !ANullGuid($thisguid))
	{

		$guiddn = "GUID=".$thisguid;

		//echo "GUIDDN is : ". $guiddn."<br>";

	 	XSearchFor($guiddn,0,"","");
	 	
	}
}

function XDelete($p1)
{

	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;
	global $mgrresult;


	// $p1 is guid
	if ($mgrresult == "")
	{
		$ldapresult = @ldap_delete($httpdmgr,$p1);

		if (!$ldapresult)
		{	// some error
			$errno = ldap_errno($httpdmgr);
			$mgrresult = ldap_err2str($errno);
			ErrorAction("Delete",$mgrresult,$p1,"","","","");
		}
	}
}

function XModifyRDN($p1,$p2,$p3,$p4,$p5)
{


	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;
	global $mgrresult;
	global $thisguid;


	// $p1 is parent
	// $p2 is attribute name (usually "cn")
	// $p3 is new value
	// $p4 is old value
	// $p5 is container


	if ($mgrresult == "")
	{

		$theparent = "";
		if ($p1 != "")
		{
			$theparent = $theparent."GUID=".$p1.",";
		}
		$theparent = $theparent."cn=".$p5;
		//$olddn = $p2."=".$p4.",".$theparent;
		$olddn = "GUID=".$thisguid;
		$newdn = $p2."=".$p3;

		$ldapresult = @ldap_rename ( $httpdmgr,$olddn,$newdn,$theparent,true);
		if (!$ldapresult)
		{	// some error
			$errno = ldap_errno($httpdmgr);
			$mgrresult = ldap_err2str($errno);
			ErrorAction("ModifyRDN",$mgrresult,$p1,$p2,$p3,$p4,$p5);
		}
	}

}


function XModify($p1,$p2,$p3,$p4)
{

	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;
	global $mgrresult;


	// $p1 is guid
	// $p2 is number of attributes
	// $p3 is CS list of attr names
	// $p4 is CS list of attr values

	if ($mgrresult == "")
	{
		$names = Array();
		$values = Array();
		$info = Array();

		$nametok = strtok($p3,"\t"); 
		for ($i = 0;$i < $p2;$i++)
		{
			array_push($names,$nametok);
    			$nametok = strtok("\t");
		}

 		$valtok = strtok($p4,"\t");
		for ($i = 0;$i < $p2;$i++)
		{
			if ($valtok == "¬NULL¬")
			{
				$valtok = "";
			}
			array_push($values,$valtok);
    			$valtok = strtok("\t");
		}

		for ($i = 0;$i<$p2;$i++)
		{
			$info[$names[$i]] = $values[$i];
		}
		$ldapresult = @ldap_modify($httpdmgr,$p1,$info);

		if (!$ldapresult)
		{	// some error
			$errno = ldap_errno($httpdmgr);
			$mgrresult = ldap_err2str($errno);
			ErrorAction("Modify",$mgrresult,$p1,$p2,$p3,$p4,"");
		}

	}
}


function XAdd($p1,$p2,$p3,$p4,$p5)
{

	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;
	global $mgrresult;



	// $p1 is dn
	// $p2 is classname
	// $p3 is number of attributes
	// $p4 is CS list of attr names
	// $p5 is CS list of attr values

	if ($mgrresult == "")
	{
		$names = Array();
		$values = Array();
		$info = Array();

		$nametok = strtok($p4,"\t"); 
		for ($i = 0;$i < $p3;$i++)
		{
			array_push($names,$nametok);
    			$nametok = strtok("\t");
		}

 		$valtok = strtok($p5,"\t");
		for ($i = 0;$i < $p3;$i++)
		{
			if ($valtok == "¬NULL¬")
			{
				$valtok = "";
			}
			array_push($values,$valtok);
    			$valtok = strtok("\t");
		}

		for ($i = 0;$i<$p3;$i++)
		{
			$info[$names[$i]] = $values[$i];
		}

		$info["objectclass"] = $p2;

		$ldapresult = @ldap_add($httpdmgr,$p1,$info);
	  	if (!$ldapresult)
	  	{	// some error
	  		$errno = ldap_errno($httpdmgr);
	 		$mgrresult = ldap_err2str($errno);
	  		ErrorAction("Add",$mgrresult,$p1,$p2,$p3,$p4,$p5);
	  	}

	}
}


function XGetNamedAttribute($attr)
{

	global $guiddn;
	global $atsubobject;
	global $ldapinfo;

	if ($atsubobject != -1)
	{
	 	XSearchFor($guiddn,0,"","");
		$atsubobject = -1;
	}

	$ret = "";
	if ($attr != "")
	{
		if (array_key_exists(strtolower($attr),$ldapinfo[0]))
			$ret = $ldapinfo[0][strtolower($attr)][0];
	}
    
	return $ret;

}

function XGetNamedSubAttribute($cnval,$attr)
{

	global $guiddn;
	global $atsubobject;
	global $ldapinfo;
	global $mgrresult;
	global $subguid;

	$ret = "";

	if ($atsubobject != $cnval)
	{
		$filt = "(cn=".$cnval.")";
	 	XSearchFor($guiddn,1,$filt,"");
		if ($mgrresult != "")
		{	// no valid subobject so ignore it (do not report error)
			$mgrresult = "";
			$_SESSION[ErrorReport]="";
			return $ret;
		}
		$subguid[$cnval] = $ldapinfo[0]["guid"][0];
		$atsubobject = $cnval;
	}

	if ($attr != "")
	{
		$ret = $ldapinfo[0][strtolower($attr)][0];
	}
	return $ret;

}

function XGetNameFromGuid($guid,$name)
{

	global $ldapinfo;
	global $currentguid;
	global $currentobjclass;
	global $mgrresult;
	global $guiddn;
	global $atsubobject;

	$ret = "";
	if ($guid != "")
	{
		$firstval = "GUID=";
		$currentguid = $guid;
		if (!AGuid($currentguid))
		{
    			$currentguid = $ldapinfo[0][strtolower($guid)][0];
		}
    		if (($currentguid != "") && !ANullGuid($currentguid))
    		{
	    		$firstval = $firstval.$currentguid;
			XSearchFor($firstval,0,"","");
			if ($mgrresult != "")
			{	// we have an invalid guid so ignore it (do not report error)
				$mgrresult = "";
				$_SESSION[ErrorReport]="";
				$currentguid = GetNullGuid();
			}
			else
			{
    				$ret = $ldapinfo[0][strtolower($name)][0];
    				$currentobjclass = $ldapinfo[0]["objectclass"][0];
			}
			XSearchFor($guiddn,0,"","");  // re-establish context
			$atsubobject = -1; 
		}
	}
	return $ret;
}


function XGetDistName($objectclass)
{
	$ret = "cn";
	switch ($objectclass)
	{
		case accessRight:
			$ret = location;
			break;
		case License:
			$ret = license;
			break;
		case Message:
		case DNDException:
		case SpeedDial:
		case RingTune:
		case VoicemailContact:
		case CallerID:
			$ret = telephonenumber;
			break;
		case Capability:
			$ret = "capability";
			break;
		case Member:
			$ret = "member";
			break;
		case IPRoute:
			$ret = "ipaddress";
			break;
		case DDIEntry:
			$ret = "translateto";
			break;
		case DPEntry:
			$ret = "action";
			break;
		case LCREntry:
			$ret = "actionprimary";
			break;
		case TrunkRef:
			$ret = "trunk";
			break;
		case TimeBand:
			$ret = "startdayofweek";
			break;
		case Note:
			$ret = "datetime";
			break;

		default:
			$ret = "cn";
			break;

	}
	return $ret;

}

function SetFormAction($action,$pagename)
{

	global $addpage;
	global $modpage;
	global $ldepth;
	global $cdepth;
	global $ndepth;
	global $rdepth;

	global $thispagename;
	global $thisdepth;
	global $thisretdepth;
	global $thisnxtdepth;
	global $thisdisplaydepth;

	global $thisguid;
	global $thisdisplayguid;
	global $thisselectguid;

	global $thiscont;
	global $thisdisplaycont;

	global $thisclassname;
	global $thisdisplayclassname;
	global $thisupperclassname;

	global $thisparent;

	global $thisaction;
	global $thisname;
	global $thislistname;
	global $thisattribute;

	global $thisdirection;
	global $thisindex;
	global $thistab;

	$actstr = "";
	$pn = "";

	if ($pagename == "entitylist")
	{
		$pn = "entitylist";
        $thisselectguid++;

	}
	else if ($pagename == "subentitylist")
	{
		$pn = "subentitylist";
	}
	else if ($action == "add")
	{
		$pn = $addpage;
	}
	else
	{
		$pn = $modpage;
	}

	$pn = strtolower($pn);
	$actstr = $pn.".php";
	$actstr = $actstr."?pn=".$pn;

	$actstr = $actstr."&de=".$cdepth;
	//$actstr = $actstr."&rde=".$cdepth;
	$actstr = $actstr."&rde=".$rdepth;
	//$actstr = $actstr."&nde=".$ndepth;
	$actstr = $actstr."&nde=".$cdepth;  // never change depth from a form submit
	$actstr = $actstr."&dde=".$thisdisplaydepth;

	$actstr = $actstr."&gu=".$thisguid;
	$actstr = $actstr."&dgu=".$thisdisplayguid;
    
	$actstr = $actstr."&sgu=".$thisselectguid;

	$actstr = $actstr."&co=".$thiscont;
	$actstr = $actstr."&dco=".$thisdisplaycont;

	$actstr = $actstr."&cl=".$thisclassname;
	$actstr = $actstr."&dcl=".$thisdisplayclassname;
	$actstr = $actstr."&ucl=".$thisupperclassname;

	$actstr = $actstr."&pa=".$thisparent;

	$actstr = $actstr."&act=".$thisaction;
	$actstr = $actstr."&na=".$thisname;
	$actstr = $actstr."&lna=".$thislistname;
	$actstr = $actstr."&att=".$thisattribute;

	$actstr = $actstr."&dir=".$thisdirection;
	$actstr = $actstr."&ind=".$thisindex;


	return $actstr;
}

function SetFirstHrefAction($Apn,$Ade,$Arde,$Ande,$Aco,$Acl,$Aucl,$Ana,$Aact,$Alna)
{

	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;

	global $addpage;
	global $modpage;
	global $ldepth;
	global $cdepth;
	global $ndepth;
	global $rdepth;

	global $thispagename;
	global $thisdepth;
	global $thisretdepth;
	global $thisnxtdepth;
	global $thisdisplaydepth;

	global $thisguid;
	global $thisdisplayguid;
	global $thisselectguid;

	global $thiscont;
	global $thisdisplaycont;

	global $thisclassname;
	global $thisdisplayclassname;
	global $thisupperclassname;

	global $thisparent;

	global $thisaction;
	global $thisname;
	global $thislistname;
	global $thisattribute;

	global $thisdirection;
	global $thisindex;
	global $thistab;



	$actstr = "";

	$thispagename = strtolower($Apn);
	$thisdepth = $Ade;
	$thisretdepth = $Arde;
	$thisnxtdepth = $Ande;
	$thiscont = $Aco;
	$thisclassname = $Acl;
	$thisupperclassname = $Aucl;
	$thisname = $Ana;
	$thisaction = $Aact;
	$thislistname = $Alna;

	$_SESSION[Depth] = 0;

	$actstr = $thispagename.".php";
	$actstr = $actstr."?pn=".$thispagename;

	$actstr = $actstr."&de=".$Ade;
	$actstr = $actstr."&rde=".$Arde;
	$actstr = $actstr."&nde=".$Ande;

	$actstr = $actstr."&co=".$Aco;
	$actstr = $actstr."&cl=".$Acl;
	$actstr = $actstr."&ucl=".$Aucl;
	$actstr = $actstr."&na=".$Ana;
	$actstr = $actstr."&act=".$Aact;
	$actstr = $actstr."&lna=".$Alna;
    
//    if ($thisselectguid < 100)
//    {
//        $thisselectguid = 100;
//    }
	$actstr = $actstr."&sgu=".$thisselectguid;
    $actstr = $actstr."&ind=0";

    

	return $actstr;
}

function SetHrefAction($action,$entity)
{

	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;

	global $addpage;
	global $modpage;
	global $ldepth;
	global $cdepth;
	global $ndepth;
	global $rdepth;
	global $currentguid;
	global $guiddn;
	global $atsubobject;

	global $thispagename;
	global $thisdepth;
	global $thisretdepth;
	global $thisnxtdepth;
	global $thisdisplaydepth;

	global $thisguid;
	global $thisdisplayguid;
	global $thisselectguid;

	global $thiscont;
	global $thisdisplaycont;

	global $thisclassname;
	global $thisdisplayclassname;
	global $thisupperclassname;

	global $thisparent;

	global $thisaction;
	global $thisname;
	global $thislistname;
	global $thisattribute;

	global $thisdirection;
	global $thisindex;
	global $thistab;


	$actstr = "";
	$pn = "";

	if (($entity == "Capability") ||
		($entity == "VoicemailContact") ||
		($entity == "SpeedDial") ||
		($entity == "TimeBand") ||
		($entity == "CallerID") ||
		($entity == "DNDException") ||
		($entity == "RingTune"))
	{
		$actstr = strtolower($entity);
		$actstr = $actstr.".php";
		$actstr = $actstr."?pn=".$entity;
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;

		$actstr = $actstr."&gu=".$thisguid;
		$actstr = $actstr."&dgu=".$thisdisplayguid;
		$actstr = $actstr."&sgu=".$thisselectguid;

		$actstr = $actstr."&co=".$thiscont;
		$actstr = $actstr."&dco=".$thisdisplaycont;

		$actstr = $actstr."&cl=".$entity;
		$actstr = $actstr."&dcl=".$thisdisplayclassname;
		$actstr = $actstr."&ucl=".$thisclassname;

		$actstr = $actstr."&pa=".$thisguid;

		$actstr = $actstr."&na=".$entity;
		$actstr = $actstr."&att=".$thisattribute;
		$actstr = $actstr."&lna=".$entity;
	}
	else if ($entity == "Administrator")
	{
		$actstr = "entitylist.php";
		$actstr = $actstr."?pn=entitylist";
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;

		$actstr = $actstr."&gu=".$thisguid;
		$actstr = $actstr."&dgu=".$thisdisplayguid;
		$actstr = $actstr."&sgu=".$thisselectguid;

		$actstr = $actstr."&co=".$thisguid;
		$actstr = $actstr."&dco=".$thisdisplaycont;

		$actstr = $actstr."&cl=".$entity;
		$actstr = $actstr."&dcl=".$thisdisplayclassname;
		$actstr = $actstr."&ucl=";

		$actstr = $actstr."&pa=";

		$actstr = $actstr."&na=".$entity;
		$actstr = $actstr."&att=".$thisattribute;
		$actstr = $actstr."&lna=".$entity;
	}
	else if ($entity == "License")
	{
		$actstr = "entitylist.php";
		$actstr = $actstr."?pn=entitylist";
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;

		$actstr = $actstr."&gu=".$thisguid;
		$actstr = $actstr."&dgu=".$thisdisplayguid;
		$actstr = $actstr."&sgu=".$thisselectguid;

		$actstr = $actstr."&co=".$thisguid;
		$actstr = $actstr."&dco=".$thisdisplaycont;

		$actstr = $actstr."&cl=".$entity;
		$actstr = $actstr."&dcl=".$thisdisplayclassname;
		$actstr = $actstr."&ucl=";

		$actstr = $actstr."&pa=";

		$actstr = $actstr."&na=".$entity;
		$actstr = $actstr."&att=".$thisattribute;
		$actstr = $actstr."&lna=".$entity;
	}
	else if ($entity == "initialPhone")
	{
		$pageext = "";
		if (($currentguid != "") && !ANullGuid($currentguid))
		{
		    $sguid = "GUID=".$currentguid;
//		    XSearchFor(sguid,0,"","");
//		    pageext = HttpdMgr.MgrGetNamedAttribute("typeOfPhone");
//		    XSearchFor(guiddn,0,"","");  // re-establish context
//		    atsubobject = -1; 
		}
		$pn = "phone".$pageext;
		$actstr = $pn.".php";
		$actstr = $actstr."?pn=".$pn;
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&gu=".$currentguid;

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=Modules";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&dcl=".$thisclassname;

		$actstr = $actstr."&cl=Phone";
		$actstr = $actstr."&na=".$thisname;
	}
	else if ($entity == "dialPlan")
	{
		$actstr = "dialplan.php";
		$actstr = $actstr."?pn=dialplan";
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&gu=".$currentguid;

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=DialPlans";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&cl=DialPlan";
		$actstr = $actstr."&dcl=".$thisclassname;

		$actstr = $actstr."&na=".$thisname;
	}
	else if ($entity == "timePlan")
	{
		$actstr = "timeplan.php";
		$actstr = $actstr."?pn=timeplan";
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde


		$actstr = $actstr."&gu=".$currentguid;

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=TimePlans";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&cl=TimePlan";
		$actstr = $actstr."&dcl=".$thisclassname;

		$actstr = $actstr."&na=".$thisname;
	}
	else if ($entity == "ddiCallPlan")
	{
		$actstr = "ddicallplan.php";
		$actstr = $actstr+"?pn=ddicallplan";
		$actstr = $actstr+"&de=".$cdepth;
		$actstr = $actstr+"&rde=".$cdepth;
		$actstr = $actstr+"&nde=".$ndepth;
		$actstr = $actstr+"&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr+"&gu=".$currentguid;
		
		$actstr = $actstr+"&dgu=".$thisguid;
		$actstr = $actstr+"&sgu=".$thisguid;

		$actstr = $actstr+"&co=DDICallPlans";
		$actstr = $actstr+"&dco=".$thiscont;

		$actstr = $actstr+"&cl=DDICallPlan";
		$actstr = $actstr+"&dcl=".$thisclassname;

		$actstr = $actstr+"&na=".$thisname;
	}
	else if (($entity == "supervisorOf") ||
	         ($entity == "phoneGroup") ||
	         ($entity == "userGroup") ||
	         ($entity == "recordGroup") ||
             	 ($entity == "distributionGroup") ||
             	 ($entity == "outOfHoursDistributionGroup") ||
             	 ($entity == "alternateDistributionGroup") ||
             	 ($entity == "alternateDistributionGroup2"))

	{
		$actstr = "group.php";
		$actstr = $actstr+"?pn=group";
		$actstr = $actstr+"&de=".$cdepth;
		$actstr = $actstr+"&rde=".$cdepth;
		$actstr = $actstr+"&nde=".$ndepth;
		$actstr = $actstr+"&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr+"&gu=".$currentguid;
		
		$actstr = $actstr+"&dgu=".$thisguid;
		$actstr = $actstr+"&sgu=".$thisguid;

		$actstr = $actstr+"&co=Groups";
		$actstr = $actstr+"&dco=".$thiscont;

		$actstr = $actstr+"&cl=Group";
		$actstr = $actstr+"&dcl=".$thisclassname;

		$actstr = $actstr+"&na=".$thisname;
	}
	else if (($entity == "publicFirewall") ||
		 ($entity == "firewall"))
	{
		$subguid = "";
		
		if ($entity == "publicFirewall")
		{	//	ensure correct subguid
//			XSearchFor(guiddn,1,"(cn=1)","");
//			subguid = HttpdMgr.MgrGetNamedAttribute("GUID");
		
			// and back to main
//	 		XSearchFor(guiddn,0,"","");
//			atsubobject = -1; 
	 	}
		$actstr = "firewall.php";
		$actstr = $actstr."?pn=firewall";
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = actstr+"&gu=".$currentguid;
		
		$actstr = actstr+"&dgu=".$thisguid;
		if ($subguid != "")
		{
			$actstr = $actstr."&sgu=".$subguid;
		}
		else
		{
			$actstr = $actstr."&sgu=".$thisguid;
		}

		$actstr = $actstr."&co=Firewalls";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&dcl=".$thisclassname;
		$actstr = $actstr."&cl=Firewall";

		$actstr = $actstr."&na=".$thisname;

	}
	else if (($entity == "location") ||
             ($entity == "remoteLocation") ||
             ($entity == "sourceModule") ||
             ($entity == "currentHome"))
	{
		$pageext = "";
		if (($currentguid != "") && !ANullGuid($currentguid))
		{
			$sguid = "GUID=".$currentguid;
//			XSearchFor(sguid,0,"","");
//			pageext = HttpdMgr.MgrGetNamedAttribute("moduleType");
//			XSearchFor(guiddn,0,"","");  // re-establish context
//		    atsubobject = -1; 
		}

		$pn = "module".$pageext;
		$actstr = $pn.".php";
		$actstr = $actstr."?pn=".$pn;
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&gu=".$currentguid;
		
		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=Modules";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&cl=Module";
		$actstr = $actstr."&dcl=".$thisclassname;

		$actstr = $actstr."&na=".$thisname;
	}
	else if ($entity == "interface")
	{
		$actstr = "wanlink.php";
		$actstr = $actstr."?pn=wanlink";
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&gu=".$currentguid;
		
		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=InternetConnections";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&cl=InternetConnection";
		$actstr = $actstr."&dcl=".$thisclassname;

		$actstr = $actstr."&na=".$thisname;
	}
	else if ($entity == "trunk") 
	{
		$actstr = "trunk.php";
		$actstr = $actstr."?pn=trunk";
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&gu=".$currentguid;
		

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=Modules";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&dcl=".$thisclassname;

		$actstr = $actstr."&cl=Trunk";
		$actstr = $actstr."&na=".$thisname;

	}
	else if ($entity == "WANPort") 
	{
		$actstr = "wanport.php";
		$actstr = $actstr."?pn=wanport";
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&gu=".$currentguid;

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=Modules";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&dcl=".$thisclassname;

		$actstr = $actstr."&cl=WANPort";
		$actstr = $actstr."&na=".$thisname;

	}
	else if ($entity == "DDIEntry") 
	{
		$actstr = "ddientry.php";
		$actstr = $actstr."?pn=ddientry";
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&gu=".$thisguid;

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=DDICallPlans";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&dcl=".$thisclassname;
		$actstr = $actstr."&pa=".$thisguid;

		$actstr = $actstr."&cl=DDIEntry";
		$actstr = $actstr."&na=".$thisname;

	}
	else if ($entity == "LCREntry") 
	{
		$actstr = "lcrentry.php";
		$actstr = $actstr."?pn=lcrentry";
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&gu=".$thisguid;

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=LeastCostCallPlans";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&dcl=".$thisclassname;
		$actstr = $actstr."&pa=".$thisguid;

		$actstr = $actstr."&cl=LCREntry";
		$actstr = $actstr."&na=".$thisname;

	}
	else if ($entity == "DPEntry") 
	{
		$actstr = "dpentry.php";
		$actstr = $actstr."?pn=dpentry";
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&gu=".$thisguid;

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=DialPlans";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&dcl=".$thisclassname;
		$actstr = $actstr."&pa=".$thisguid;

		$actstr = $actstr."&cl=DPEntry";
		$actstr = $actstr."&na=".$thisname;

	}
	else if ($entity == "Member") 
	{
		$actstr = "member.php";
		$actstr = $actstr."?pn=member";
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&gu=".$thisguid;

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=Groups";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&dcl=".$thisclassname;
		$actstr = $actstr."&pa=".$thisguid;

		$actstr = $actstr."&cl=Member";
		$actstr = $actstr."&na=".$thisname;

	}
	else if ($entity == "TrunkRef")
	{
		$actstr = "trunkref".".php";
		$actstr = $actstr."?pn=".$entity;
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&gu=".$thisguid;

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=TrunkGroups";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&dcl=".$thisclassname;
		$actstr = $actstr."&pa=".$thisguid;

		$actstr = $actstr."&cl=TrunkRef";
		$actstr = $actstr."&na=".$thisname;

	}
	else if ($entity == "WANPortRef")
	{
		$actstr = "wanportref".".php";
		$actstr = $actstr."?pn=".$entity;
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&gu=".$thisguid;

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=IntranetConnections";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&dcl=".$thisclassname;
		$actstr = $actstr."&pa=".$thisguid;

		$actstr = $actstr."&cl=WANPortRef";
		$actstr = $actstr."&na=".$thisname;

	}
	else
	{
		
		$pageext = "";
		if ($action == "add")
		{
			$actstr = $addpage.$pageext.".php";
			$actstr = $actstr."?pn=".$addpage.$pageext;
			$actstr = $actstr."&de=".$cdepth;
			$actstr = $actstr."&rde=".$cdepth;
			$actstr = $actstr."&nde=".$ndepth;

			$actstr = $actstr."&gu=".$thisguid;
			$actstr = $actstr."&na=";
		}
		else
		{
			$actstr = $modpage.".php";
			$actstr = $actstr."?pn=".$modpage;
			$actstr = $actstr."&de=".$cdepth;
			//if ($action == "delete")
			//{
			//	$actstr = $actstr."&nde=".$cdepth;  // never change depth from a delete
			//	$actstr = $actstr."&rde=".$cdepth;
			//}
			//else
			//{
				$actstr = $actstr."&nde=".$ndepth;
				$actstr = $actstr."&rde=".$rdepth;
			//}



			$actstr = $actstr."&gu=".$thisguid;
			$actstr = $actstr."&na=".$thisname;
		}

		$actstr = $actstr."&dde=".$thisdisplaydepth;
		$actstr = $actstr."&dgu=".$thisdisplayguid;
		$actstr = $actstr."&sgu=".$thisselectguid;

		$actstr = $actstr."&co=".$thiscont;
		$actstr = $actstr."&dco=".$thisdisplaycont;

		$actstr = $actstr."&cl=".$thisclassname;
		$actstr = $actstr."&dcl=".$thisdisplayclassname;
		$actstr = $actstr."&ucl=".$thisupperclassname;

		$actstr = $actstr."&att=".$thisattribute;
		$actstr = $actstr."&pa=".$thisparent;
	}


	if ($action != "")
	{
		$actstr = $actstr."&act=".$action;
	}
	else
	{
		$actstr = $actstr."&act=".$thisaction;
	}

	$actstr = $actstr."&dir=".$thisdirection;
//	$actstr = $actstr."&ind=".$thisindex;
	$actstr = $actstr."&retname=".$thisindex;

	return $actstr;
}


function SetPartialHrefAction($Apagename,$Aguid,$Acontainer,$Aparent,$Aclass,$Aname,$Adirection,$Aindex)
{

	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;

	global $addpage;
	global $modpage;
	global $ldepth;
	global $cdepth;
	global $ndepth;
	global $rdepth;
	global $currentguid;
	global $guiddn;
	global $atsubobject;

	global $thispagename;
	global $thisdepth;
	global $thisretdepth;
	global $thisnxtdepth;
	global $thisdisplaydepth;

	global $thisguid;
	global $thisdisplayguid;
	global $thisselectguid;

	global $thiscont;
	global $thisdisplaycont;

	global $thisclassname;
	global $thisdisplayclassname;
	global $thisupperclassname;

	global $thisparent;

	global $thisaction;
	global $thisname;
	global $thislistname;
	global $thisattribute;

	global $thisdirection;
	global $thisindex;
	global $thistab;


	$actstr = "";
	$entattr = "";
	$pn = "";

	if ($Aclass == "Module")
	{
		//$entattr =  "moduleType";
		$thislistname = "Module";
	}
	else if ($Aclass == "Trunk")
	{
		//$entattr =  "typeOfTrunk";
		$thislistname = "Trunk";
	}
	else if ($Aclass == "Phone")
	{
		//$entattr =  "typeOfPhone";
		$thislistname = "Phone";
	}
	else if ($Aclass == "WANLink")
	{
		$thislistname = "WANLink";
	}
	if ($entattr != "")
	{
		if (($Aguid != "") && !ANullGuid($Aguid))
		{
			$sguid = "GUID=".$Aguid;
		 	XSearchFor($sguid,0,"","");
			$pageext = $ldapinfo[0][strtolower($entattr)][0];
		}
		
	}


	$pn = $Apagename.$pageext;
	$pn = strtolower($pn);

	$actstr = $pn.".php";
	$actstr = $actstr."?pn=".$pn;

	$actstr = $actstr."&de=".$cdepth;
	if ($Adirection != "")
	{	// we move up and down in situ, do not change depths
		$actstr = $actstr."&rde=".$rdepth;
		$actstr = $actstr."&nde=".$cdepth;
	}
	else
	{
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
	}
	$actstr = $actstr."&dde=".$cdepth;  // we want to return to here


	//if (Aguid != "")
	//{
	//	actstr = actstr+"&gu="+Aguid;
	//}
	//else
	//{
	//	actstr = actstr+"&gu="+thisguid;
	//}
	$actstr = $actstr."&dgu=".$thisdisplayguid;
	$actstr = $actstr."&sgu=".$thisselectguid;

	if ($Acontainer != "")
	{
		$actstr = $actstr."&co=".$Acontainer;
	}
	else
	{
		$actstr = $actstr."&co=".$thiscont;
	}
	$actstr = $actstr."&dco=".$thisdisplaycont;

	if ($Aclass != "")
	{
		$actstr = $actstr."&cl=".$Aclass;
	}
	else
	{
		$actstr = $actstr."&cl=".$thisclassname;
	}
	$actstr = $actstr."&dcl=".$thisdisplayclassname;
	$actstr = $actstr."&ucl=".$thisupperclassname;

	if ($Aparent != "")
	{
		$actstr = $actstr."&pa=".$Aparent;
	}
	else
	{
		$actstr = $actstr."&pa=".$thisparent;
	}

	$actstr = $actstr."&act=".$thisaction;
	//if (Aname != "")
	//{
	//	actstr = actstr."&na=".Aname;
	//}
	//else
	//{
	//	actstr = actstr."&na=".thisname;
	//}
	$actstr = $actstr."&lna=".$thislistname;
	$actstr = $actstr."&att=".$thisattribute;

	if ($Adirection != "")
	{
		$actstr = $actstr."&dir=".$Adirection;
	}
	//else
	//{
	//	actstr = actstr."&dir=".thisdirection;
	//}
	if ($Aindex != "")
	{
		$actstr = $actstr."&ind=".$Aindex;
	}
	//else
	//{
	//	actstr = actstr."&ind=".thisindex;
	//}

	return $actstr;

}

function SetListHrefAction($Apagename,$Aguid,$Acontainer,$Aparent,$Aclass,$Aname,$Adirection,$Aindex)
{


	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;

	global $addpage;
	global $modpage;
	global $ldepth;
	global $cdepth;
	global $ndepth;
	global $rdepth;
	global $currentguid;
	global $guiddn;
	global $atsubobject;

	global $thispagename;
	global $thisdepth;
	global $thisretdepth;
	global $thisnxtdepth;
	global $thisdisplaydepth;

	global $thisguid;
	global $thisdisplayguid;
	global $thisselectguid;

	global $thiscont;
	global $thisdisplaycont;

	global $thisclassname;
	global $thisdisplayclassname;
	global $thisupperclassname;

	global $thisparent;

	global $thisaction;
	global $thisname;
	global $thislistname;
	global $thisattribute;

	global $thisdirection;
	global $thisindex;
	global $thistab;

	global $pageextension;


	$actstr = "";
	$entattr = "";
	$pn = "";

	$pn = $Apagename;

	if ($Apagename != "entitylist")
	{
		if (($Aclass == "Module") || ($Aclass == "UnassignedModule"))
		{
			//$entattr =  "moduleType";
			$thislistname = "Module";
			$pn = "module";
		}
		else if ($Aclass == "Trunk")
		{
			//$entattr =  "typeOfTrunk";
			$thislistname = "Trunk";
		}
		else if ($Aclass == "Phone")
		{
			//$entattr =  "typeOfPhone";
			$thislistname = "Phone";
		}
		else if ($Aclass == "WANLink")
		{
			$thislistname = "WANLink";
		}
		if ($entattr != "")
		{
			if (($Aguid != "") && !ANullGuid($Aguid))
			{

				$sguid = "GUID=".$Aguid;
			 	XSearchFor($sguid,0,"","");
				$pageext = $ldapinfo[0][strtolower($entattr)][0];
			}
		
		}
		$pn = $pn.$pageextension;
	}
	$pn = strtolower($pn);

	$actstr = $pn.".php";
	$actstr = $actstr."?pn=".$pn;

	$actstr = $actstr."&de=".$cdepth;
	if ($Adirection != "")
	{	// we move up and down in situ, do not change depths
		$actstr = $actstr."&rde=".$rdepth;
		if ($Adirection !== "stay")
		{
			$actstr = $actstr."&nde=".$cdepth;
		}
		else
		{
			$actstr = $actstr."&nde=".$ndepth;
		}
	}
	else
	{
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
	}
	$actstr = $actstr."&dde=".$thisdisplaydepth;


	if ($Aguid != "")
	{
		$actstr = $actstr."&gu=".$Aguid;
	}
	else
	{
		$actstr = $actstr."&gu=".$thisguid;
	}
	$actstr = $actstr."&dgu=".$thisdisplayguid;
	$actstr = $actstr."&sgu=".$thisselectguid;

	if ($Acontainer != "")
	{
		$actstr = $actstr."&co=".$Acontainer;
	}
	else
	{
		$actstr = $actstr."&co=".$thiscont;
	}
	$actstr = $actstr."&dco=".$thisdisplaycont;

	if ($Aclass != "")
	{
		$actstr = $actstr."&cl=".$Aclass;
	}
	else
	{
		$actstr = $actstr."&cl=".$thisclassname;
	}
	$actstr = $actstr."&dcl=".$thisdisplayclassname;
	$actstr = $actstr."&ucl=".$thisupperclassname;

	if ($Aparent == "NULL")
	{
		$actstr = $actstr."&pa="."";
	}
	else if ($Aparent != "")
	{
		if ($Acontainer == "Companies")
		{
			$r = "";
			$par = "";
			if ($Aclass == "Contact")
			{
				$r = "cn=Contacts";
			}
			else if ($Aclass == "AutoAttendantKey")
			{
				$r = "cn=AutoAttendant";
			}
			else if ($Aclass == "ExtendedAttendant")
			{
				$r = "cn=AutoAttendant";
			}
			else if ($Aclass == "User")
			{
				$r = "cn=Users";
			}
			else if ($Aclass == "Department")
			{
				$r = "cn=Departments";
			}
			else if ($Aclass == "MeetMeConference")
			{
				$r = "cn=MeetMeConferences";
			}

			if ($r != "")
			{
				$allthese = Array("guid");

				$re = "GUID=".$Aparent;

				$lr = @ldap_list($httpdmgr,$re,$r,$allthese,0,1);
				if ($lr)
				{
					$info = ldap_get_entries($httpdmgr, $lr);
					if ($info["count"] != 0)
						$par = $info[0]["guid"][0];
					$actstr = $actstr."&pa=".$par;
				}
			}
			else
			{
				$actstr = $actstr."&pa=".$Aparent;
			}
		}
		else
		{
			$actstr = $actstr."&pa=".$Aparent;
		}
	}
	else
	{
		$actstr = $actstr."&pa=".$thisparent;
	}



	if (substr($Apagename,0,3) == "add")
	{
		$actstr = $actstr."&act=add";

	}
	else
	{
		$actstr = $actstr."&act=".$thisaction;
	}

	if ($Aname != "")
	{
		$actstr = $actstr."&na=".$Aname;
	}
	else
	{
		$actstr = $actstr."&na=".$thisname;
	}
	if (($Apagename == "entitylist") && ($Aclass != ""))
	{	// we are listing an "owned" class
		$actstr = $actstr."&lna=".$Aclass;
	}
	else
	{
		$actstr = $actstr."&lna=".$thislistname;
	}
	$actstr = $actstr."&att=".$thisattribute;

	if ($Adirection != "")
	{
		$actstr = $actstr."&dir=".$Adirection;
	}
	//else
	//{
	//	actstr = actstr+"&dir="+thisdirection;
	//}
	if ($Aindex != "")
	{
		$actstr = $actstr."&retname=".$Aindex;
	}
	//else
	//{
	//	actstr = actstr+"&ind="+thisindex;
	//}

	return $actstr;

}

function SetFindHrefAction($Acontainer,$Aentity)
{
	global $thisguid;
	global $httpdmgr;

	$dn = "cn=".$Acontainer;
	$filt = $Aentity."=".$thisguid;
	$allthese = Array("cn","guid");

	$outcome = @ldap_list($httpdmgr,$dn,$filt,$allthese);

	if (!$outcome)
		return "";

    	$info = ldap_get_entries($httpdmgr, $outcome);

	if ($info["count"] == 0)
		return "";

	if ($Acontainer == "Users")
	{
		return SetListHrefAction("user",$info[0]["guid"][0],"Users","NULL","User",$info[0]["cn"][0],"","");
	}

}

function GetPageExt($entity)
{

	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;
	global $currentguid;
	global $guiddn;
	global $atsubobject;

	$pageext = "";

	if (($currentguid != "") && !ANullGuid($currentguid))
	{
		$sguid = "GUID=".$currentguid;
		switch ($entity)
		{
		 	case "initialPhone":
				XSearchFor($sguid,0,"","");
				$pageext = $ldapinfo[0]["typeofphone"][0];
				XSearchFor($guiddn,0,"","");  // re-establish context
				$atsubobject = -1; 
				break;
			case "location":
            case "remoteLocation":
			case "currentHome":
			case "sourceModule":
		 		XSearchFor($sguid,0,"","");
				$pageext = $ldapinfo[0]["moduletype"][0];
				XSearchFor($guiddn,0,"","");  // re-establish context
			    	$atsubobject = -1; 
				break;
			case "trunk":
		 		XSearchFor($sguid,0,"","");
				$pageext = $ldapinfo[0]["typeoftrunk"][0];
				XSearchFor($guiddn,0,"","");  // re-establish context
			    	$atsubobject = -1; 
				break;

		}
	}

	return $pageext;
}

function SetGoToHrefAction($action,$entity)
{


	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;

	global $addpage;
	global $modpage;
	global $ldepth;
	global $cdepth;
	global $ndepth;
	global $rdepth;
	global $currentguid;
	global $guiddn;
	global $atsubobject;

	global $thispagename;
	global $thisdepth;
	global $thisretdepth;
	global $thisnxtdepth;
	global $thisdisplaydepth;

	global $thisguid;
	global $thisdisplayguid;
	global $thisselectguid;

	global $thiscont;
	global $thisdisplaycont;

	global $thisclassname;
	global $thisdisplayclassname;
	global $thisupperclassname;

	global $thisparent;

	global $thisaction;
	global $thisname;
	global $thislistname;
	global $thisattribute;

	global $thisdirection;
	global $thisindex;
	global $thistab;


	$actstr = "";
	$pn = "";

	if ($entity == "initialPhone")
	{
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=Modules";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&dcl=".$thisclassname;

		$actstr = $actstr."&cl=Phone";
	}
	else if ($entity == "dialPlan")
	{
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=DialPlans";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&cl=DialPlan";
		$actstr = $actstr."&dcl=".$thisclassname;
	}
	else if ($entity == "timePlan")
	{
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=TimePlans";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&cl=TimePlan";
		$actstr = $actstr."&dcl=".$thisclassname;
	}
	else if ($entity == "company")
	{
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=Companies";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&cl=Company";
		$actstr = $actstr."&dcl=".$thisclassname;
	}
	else if ($entity == "ddiCallPlan")
	{
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=DDICallPlans";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&cl=DDICallPlan";
		$actstr = $actstr."&dcl=".$thisclassname;
	}
	else if (($entity == "supervisorOf") ||
	         ($entity == "phoneGroup") ||
	         ($entity == "userGroup") ||
	         ($entity == "recordGroup") ||
             	 ($entity == "distributionGroup") ||
             	 ($entity == "outOfHoursDistributionGroup") ||
             	 ($entity == "alternateDistributionGroup") ||
             	 ($entity == "alternateDistributionGroup2"))

	{
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=Groups";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&cl=Group";
		$actstr = $actstr."&dcl=".$thisclassname;
	}
	else if (($entity == "publicFirewall") ||
		 ($entity == "firewall"))
	{
		$subguid = "";
		
		if ($entity == "publicFirewall")
		{	//	ensure correct subguid
			XSearchFor($guiddn,1,"(cn=1)","");
			$subguid = $ldeapinfo[0]["guid"][0];
		
			// and back to main
	 		XSearchFor($guiddn,0,"","");
			$atsubobject = -1; 
	 	}
	 	
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&dgu=".$thisguid;
		if ($subguid != "")
		{
			$actstr = $actstr."&sgu=".$subguid;
		}
		else
		{
			$actstr = $actstr."&sgu=".$thisguid;
		}

		$actstr = $actstr."&co=Firewalls";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&dcl=".$thisclassname;
		$actstr = $actstr."&cl=Firewall";
	}
	else if (($entity == "location") ||
             ($entity == "remoteLocation") ||
             ($entity == "sourceModule") ||
             ($entity == "currentHome"))
	{
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=Modules";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&cl=Module";
		$actstr = $actstr."&dcl=".$thisclassname;
	}
	else if (($entity == "departmentVoicemail") ||
		 ($entity == "departmentVoicemail2") ||
		 ($entity == "departmentVoicemail3") ||
		 ($entity == "departmentVoicemail4"))
	{
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=Departments";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&cl=Department";
		$actstr = $actstr."&dcl=".$thisclassname;
	}
	else if ($entity == "interface")
	{
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=Modules";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&cl=WANLink";
		$actstr = $actstr."&dcl=".$thisclassname;
	}
	else if ($entity == "User")
	{
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=Users";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&cl=User";
		$actstr = $actstr."&dcl=".$thisclassname;
	}
	else if ($entity == "trunk") 
	{
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde

		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=Modules";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&dcl=".$thisclassname;

		$actstr = $actstr."&cl=Trunk";
	}
	else if ($entity == "wanPort") 
	{
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde


		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=Modules";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&dcl=".$thisclassname;

		$actstr = $actstr."&cl=WANPort";
	}
	else if ($entity == "DDIEntry") 
	{
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde


		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=DDICallPlans";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&dcl=".$thisclassname;
		$actstr = $actstr."&pa=".$thisguid;

		$actstr = $actstr."&cl=DDIEntry";
	}
	else if ($entity == "LCREntry") 
	{
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde


		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=LeastCostCallPlans";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&dcl=".$thisclassname;
		$actstr = $actstr."&pa=".$thisguid;

		$actstr = $actstr."&cl=LCREntry";
	}
	else if ($entity == "DPEntry") 
	{
		$actstr = $actstr."&de=".$cdepth;
		$actstr = $actstr."&rde=".$cdepth;
		$actstr = $actstr."&nde=".$ndepth;
		$actstr = $actstr."&dde=".$cdepth;  // must return here, override rde


		$actstr = $actstr."&dgu=".$thisguid;
		$actstr = $actstr."&sgu=".$thisguid;

		$actstr = $actstr."&co=DialPlans";
		$actstr = $actstr."&dco=".$thiscont;

		$actstr = $actstr."&dcl=".$thisclassname;
		$actstr = $actstr."&pa=".$thisguid;

		$actstr = $actstr."&cl=DPEntry";
	}
	else
	{
		
		$pageext = "";
		if ($action == "add")
		{
			$actstr = addpage.pageext.".php";
			$actstr = $actstr."?pn=".$addpage.$pageext;
			$actstr = $actstr."&de=".$cdepth;
			$actstr = $actstr."&rde=".$cdepth;
			$actstr = $actstr."&nde=".$ndepth;

			$actstr = $actstr."&gu=".$thisguid;
			$actstr = $actstr."&na=";
		}
		else
		{
			$actstr = $modpage.".php";
			$actstr = $actstr."?pn=".$modpage;
			$actstr = $actstr."&de=".$cdepth;
			//$actstr = $actstr."&rde=".$cdepth;
			$actstr = $actstr."&rde=".$rdepth;
			$actstr = $actstr."&nde=".$ndepth;

			$actstr = $actstr."&gu=".$thisguid;
			$actstr = $actstr."&na=".$thisname;
		}
		$actstr = $actstr."&dde=".$thisdisplaydepth;

		$actstr = $actstr."&dgu=".$thisdisplayguid;
		$actstr = $actstr."&sgu=".$thisselectguid;

		$actstr = $actstr."&co=".$thiscont;
		$actstr = $actstr."&dco=".$thisdisplaycont;

		$actstr = $actstr."&cl=".$thisclassname;
		$actstr = $actstr."&dcl=".$thisdisplayclassname;
		$actstr = $actstr."&ucl=".$thisupperclassname;

		$actstr = $actstr."&att=".$thisattribute;
		$actstr = $actstr."&pa=".$thisparent;
	}


	if ($action != "")
	{
		$actstr = $actstr."&act=".$action;
	}
	else
	{
		$actstr = $actstr."&act=".$thisaction;
	}

	$actstr = $actstr."&dir=".$thisdirection;
	$actstr = $actstr."&ind=".$thisindex;
	$actstr = $actstr."&".session_name()."=".session_id();

	return $actstr;

}

// list processing functions

function ProcessValue($classname,$attrname,$attrval)
{

	global $displayphonetype;
	global $DialAction;
	global $RingTuneType;
	global $VoicemailContactType;
	global $VoicemailContactType;
	global $OutOfHoursMode;
	global $RecordMode;
	global $DistributionMode;
	global $ModuleType;
	global $ModuleStatus;
	global $AdministrationMode;
	global $DHCPMode;
	global $RipMode;
	global $AuthenticationMethod;
	global $TypeOfPhone;
	global $CallerDisplayType;
	global $SplicePhoneModel;
	global $IPPhoneModel;
	global $TypeOfTrunk;
	global $OutOfOffice;
	global $AutoURL;
	global $VoicemailCapability;
	global $AutoAttendantAction;


	$retval = $attrval;

	if ($classname != "Phone")
	{
		$displayphonetype = "";  // keep this value while a phone is being processed
	}

	if ($classname == "DPTranslateTo")
	{
		if ($attrname == "action")
		{
			$retval = $DialAction[$attrval];
		}
	}
	else if ($classname == "RingTune")
	{
		if ($attrname == "type")
		{
			$retval = $RingTuneType[$attrval];
		}
	}
	else if ($classname == "VoicemailContact")
	{
		if ($attrname == "type")
		{
			$retval = $VoicemailContactType[$attrval];
		}
		else if ($attrname == "method")
		{
			$retval = $VoicemailContactMethod[$attrval];
		}
	}
	else if ($classname == "Department")
	{
		if ($attrname == "outOfHoursMode")
		{
			$retval = $OutOfHoursMode[$attrval];
		}
		else if ($attrname == "recordMode")
		{
			$retval = $RecordMode[$attrval];
		}
	}
	else if ($classname == "Group")
	{
		if ($attrname == "distributionMode")
		{
			$retval = $DistributionMode[$attrval];
		}
	}
	else if (($classname == "Module") || ($classname == "UnassignedModule"))
	{
		if ($attrname == "moduleType")
		{
			$retval = $ModuleType[$attrval];
		}
		else if ($attrname == "moduleStatus")
		{
			$retval = $ModuleStatus[$attrval];
		}
		else if ($attrname == "administrationMode")
		{
			$retval = $AdministrationMode[$attrval];
		}
		else if ($attrname == "dhcpServerMode")
		{
			$retval = $DHCPMode[$attrval];
		}
		else if ($attrname == "ripMode")
		{
			$retval = $RIPMode[$attrval];
		}
		else if ($attrname == "authenticationMethod")
		{
			$retval = $AuthenticationMethod[$attrval];
		}
		else if ($attrname == "operationMode")
		{
			$retval = $ExternalOperationMode[$attrval];
		}
	}
	else if ($classname == "UnassignedPhone")
	{
		if ($attrname == "status")
		{
			$retval = $ModuleStatus[$attrval];
		}
		else if ($attrname == "typeOfPhone")
		{
			$retval = $TypeOfPhone[$attrval];
		}
	}
	else if ($classname == "Phone")
	{
		if ($attrname == "typeOfPhone")
		{
			$retval = $TypeOfPhone[$attrval];
			$displayphonetype = $retval;
		}
		else if ($attrname == "callerDisplayType")
		{
			$retval = $CallerDisplayType[$attrval];
		}
		else if ($attrname == "model")
		{
			if ($displayphonetype = "PTSplicePhone")
			{
				$retval = $SplicePhoneModel[$attrval];
			}
			else if ($displayphonetype = "PTGenericIPPhone")
			{
				$retval = $IPPhoneModel[$attrval];
			}
		}
		else if ($attrname == "moduleType")
		{
			$retval = $ModuleType[$attrval];
		}

	}
	else if ($classname == "Trunk")
	{
		if ($attrname == "typeOfTrunk")
		{
			$retval = $TypeOfTrunk[$attrval];
		}
		else if ($attrname == "moduleType")
		{
			$retval = $ModuleType[$attrval];
		}
	}
	else if ($classname == "WANPort")
	{
		if ($attrname == "moduleType")
		{
			$retval = $ModuleType[$attrval];
		}
	}
	else if ($classname == "User")
	{
		if ($attrname == "outOfOffice")
		{
			$retval = $OutOfOffice[$attrval];
		}
		else if ($attrname == "autoURL")
		{
			$retval = $AutoURL[$attrval];
		}
	}
	else if ($classname == "VoicemailPort")
	{
		if ($attrname == "capability")
		{
			$retval = $VoicemailCapability[$attrval];
		}
	}
	else if ($classname == "Contact")
	{
		if ($attrname == "autoURL")
		{
			$retval = $AutoURL[$attrval];
		}
	}
	else if ($classname == "AutoAttendantKey")
	{
		if ($attrname == "action")
		{
			$retval = $AutoAttendantAction[$attrval];
		}
	}

	return $retval;
}


function IsolateAttrVal($nameandval)
{

	global $thisclassname;
	global $pageextension;


	$pageextension = "";

	$attrname = "";
	$attrval = "";
	if ($nameandval == "")
	{
		return "";
	}
	
	$endind = strlen($nameandval);
	$stat = 0;
	$possp = substr($nameandval,$stat,1);
	while ($possp != ",")
	{
		$stat++;
		if ($stat >= $endind)
		{
			return "";
		}
		$possp = substr($nameandval,$stat,1);
	}
	$attrname = substr($nameandval,0,$stat);
	if (($attrname == "objectclass") || ($attrname == "GUID"))
	{
		return "";
	}

	if (stristr($attrname,"password"))
	{
		return "";  // do not want to show value
	}


	$stat++;
	$attrval = substr($nameandval,$stat,$endind);

	if (($thisclassname == "Module") || ($thisclassname == "UnassignedModule"))
	{
		if ($attrname == "moduleType")
		{
			$pageextension = $attrval;
		}
	}
	if ($thisclassname == "Trunk")
	{
		if ($attrname == "typeOfTrunk")
		{
			$pageextension = $attrval;
		}
	}
	if ($thisclassname == "Phone")
	{
		if ($attrname == "typeOfPhone")
		{
			$pageextension = $attrval;
		}
	}

	$attrval = ProcessValue($thisclassname,$attrname,$attrval);  // check for enum values

	return $attrval;
}

function GetDN($attr,$attrattr)
{

	global $httpdmgr;

	if (ANullGuid($attr))
	{
		return "";
	}
	$lr = ldap_read($httpdmgr,"GUID=".$attr,"(objectclass=*)");
	if ($lr)
	{
		$attrdn = ldap_get_dn($httpdmgr,ldap_first_entry($httpdmgr,$lr));
		if ($attrattr != "")
		{	// we need dotted notation
			$attra = ldap_explode_dn($attrdn,1);
			return $attra[1].".".$attra[0];
		}
		else
		{	// 'cn' notation
			return $attrdn;
		}
	}
	else
		return "";
}

function EscapeBrackets($bracketstring)
{
    $returnstring = $bracketstring;
    
    $splitarray = Array();
    $splitarray = split("\(", $returnstring);
    
    $splitind = 0;
    $splitsize = count($splitarray);
    
    for ($splitind = 0;$splitind < ($splitsize-1);$splitind++)   
    {
        $splitarray[$splitind] = $splitarray[$splitind]."\(";
    }
    
    $returnstring = "";
    
    for ($splitind = 0;$splitind < $splitsize;$splitind++)   
    {
        $returnstring = $returnstring.$splitarray[$splitind];
    }
    
    $splitarray = split("\)", $returnstring);
    $splitind = 0;
    $splitsize = count($splitarray);
    
    for ($splitind = 0;$splitind < ($splitsize-1);$splitind++)   
    {
        $splitarray[$splitind] = $splitarray[$splitind]."\)";
    }
    
    $returnstring = "";
    
    for ($splitind = 0;$splitind < $splitsize;$splitind++)   
    {
        $returnstring = $returnstring.$splitarray[$splitind];
    }
    
    return $returnstring;
}

function InitList($container,$classname,$startname,$direction,$search)
{
    

	global $AdministratorArray;
	global $LicenseArray;
	global $ModuleArray;
	global $VoicemailPortArray;
	global $UserArray;
	global $DepartmentArray;
	global $GroupArray;
	global $UnassignedPhoneArray;
	global $PhoneArray;
	global $TrunkArray;
	global $WANLinkArray;
	global $WANPortArray;
	global $IntranetConnectionArray;
	global $InternetConnectionArray;
	global $IPRouteArray;
	global $DDICallPlanArray;
	global $TrunkGroupArray;
	global $LeastCostCallPlanArray;
	global $DialPlanArray;
	global $TimePlanArray;
	global $FirewallArray;
	global $AreaCodeArray;
	global $MusicChannelArray;
	global $CompanyArray;
	global $AutoAttendantKeyArray;
	global $ExtendedAttendantArray;
	global $CompanyArray;
	global $ContactArray;
	global $EventArray;
	global $MeetMeConferenceArray;

	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;

	global $addpage;
	global $modpage;
	global $ldepth;
	global $cdepth;
	global $ndepth;
	global $rdepth;
	global $currentguid;
	global $guiddn;
	global $atsubobject;

	global $thispagename;
	global $thisdepth;
	global $thisretdepth;
	global $thisnxtdepth;
	global $thisdisplaydepth;

	global $thisguid;
	global $thisdisplayguid;
	global $thisselectguid;

	global $thiscont;
	global $thisdisplaycont;

	global $thisclassname;
	global $thisdisplayclassname;
	global $thisupperclassname;

	global $thisparent;

	global $thisaction;
	global $thisname;
	global $thislistname;
	global $thisattribute;

	global $thisdirection;
	global $thisindex;
	global $thistab;

	global $nameind;
	global $nents;
	global $prevpos;
	global $nextname;
	global $prevname;

	global $pageextension;

	global $resn;
	global $resg;
	global $respext;
	global $display1;
	global $display2;
	global $display3;
	global $listnames;
	global $listguids;
	global $listpexts;
	global $listdisplay1;
	global $listdisplay2;
	global $listdisplay3;


	$dn = "cn=";
	$filt = "";
	$level = 1;
	$objclass = "";
	$dname = "cn";
	$emptyind = "empty field";
	$startindex = $startname;
	if ($classname == "VoicemailPort")
	{
		$startindex = "";
	}
	$lr = "";
	$info = "";
	$initarray = Array();
	$addlogic = false;

	switch ($classname)
	{
		case "Administrator":
			$initarray = $AdministratorArray;
			break;
		case "License":
			$initarray = $LicenseArray;
			break;
		case "Module":
		case "UnassignedModule":
			$initarray = $ModuleArray;
			break;
		case "VoicemailPort":
			$initarray = $VoicemailPortArray;
			break;
		case "User":
			$initarray = $UserArray;
			break;
		case "Department":
			$initarray = $DepartmentArray;
			break;
		case "Group":
			$initarray = $GroupArray;
			break;
		case "UnassignedPhone":
			$initarray = $UnassignedPhoneArray;
			break;
		case "Phone":
			if ($thisparent == "")
				$initarray = $ModuleArray;
			else
				$initarray = $PhoneArray;
			break;
		case "Trunk":
			if ($thisparent == "")
				$initarray = $ModuleArray;
			else
				$initarray = $TrunkArray;
			break;
		case "WANLink":
			$initarray = $WANLinkArray;
			break;
		case "WANPort":
			if ($thisparent == "")
				$initarray = $ModuleArray;
			else
				$initarray = $WANPortArray;
			break;
		case "IntranetConnection":
			$initarray = $IntranetConnectionArray;
			break;
		case "InternetConnection":
			$initarray = $InternetConnectionArray;
			break;
		case "IPRoute":
			$initarray = $IPRouteArray;
			break;
		case "DDICallPlan":
			$initarray = $DDICallPlanArray;
			break;
		case "TrunkGroup":
			$initarray = $TrunkGroupArray;
			break;
		case "LeastCostCallPlan":
			$initarray = $LeastCostCallPlanArray;
			break;
		case "LeastCostCallPlan":
			$initarray = $LeastCostCallPlanArray;
			break;
		case "DialPlan":
			$initarray = $DialPlanArray;
			break;
		case "TimePlan":
			$initarray = $TimePlanArray;
			break;
		case "Firewall":
			$initarray = $FirewallArray;
			break;
		case "AreaCode":
			$initarray = $AreaCodeArray;
			break;
		case "MusicChannel":
			$initarray = $MusicChannelArray;
			break;
		case "AutoAttendantKey":
			if ($container == "Companies")
			{
				if ($thisparent == "")
					$initarray = $CompanyArray;
				else if ($thislistname == "ExtendedAttendant")
					$initarray = $ExAutoAttendantKeyArray;

				else
					$initarray = $AutoAttendantKeyArray;
			}
			else
			{

				if ($thislistname == "ExtendedAttendant")
					$initarray = $ExAutoAttendantKeyArray;

				else
					$initarray = $AutoAttendantKeyArray;
			}

			break;

		case "ExtendedAttendant":
			$initarray = $ExtendedAttendantArray;
			break;
		case "Contact":
			if ($container == "Companies")
			{
				if ($thisparent == "")
					$initarray = $CompanyArray;
				else
					$initarray = $ContactArray;
			}
			else
				$initarray = $ContactArray;
			break;
		case "Event":
			$initarray = $EventArray;
			break;
		case "Company":
			$initarray = $CompanyArray;
			break;
		case "MeetMeConference":
			if ($container == "Companies")
			{
				if ($thisparent == "")
					$initarray = $CompanyArray;
				else
					$initarray = $MeetMeConferenceArray;
			}
			else
				$initarray = $MeetMeConferenceArray;
			break;
		default:
			return 0;
	}

	$allthese = Array($initarray[0],$initarray[1],$initarray[2],$initarray[3],"guid");

	if ((($thisclassname == "User") || ($thisclassname == "Department")) && ($startname != ""))
	{	// basic test for non-numeric (may not always work)
		if (($search == 1) && ctype_digit($startname))
		{	// no alpha found, assume looking for and extn
			$re = "";

			if ($thisclassname == "User")
			{
				$re = "cn=Users";
			}
			else
			{
				$re = "cn=Departments";
			}
			if ($thisguid != "")
			{
				$re = $re.",GUID=".$thisguid;
			}
			$r = "(&(telephoneNumber=".$startindex.")(objectclass=".$thisclassname."))";

			$lr = @ldap_list($httpdmgr,$re,$r,$allthese,0,1);
			if ($lr)
			{
				$info = ldap_get_entries($httpdmgr, $lr);
				if ($info["count"] != 0)
					$startindex = $info[0]["cn"][0];
			}

		}
	}

	
	if ($startindex == $emptyind)
	{
		$startindex = "";
	}
	
	$resn[0] = "";
	$resg[0] = "";
	$display1[0] = "";
	$display2[0] = "";
	$display3[0] = "";

	if ($classname == "IPRoute")
	{
		$dname = "ipAddress";
	}
	if ($classname == "License")
	{
		$dname = "key";
	}
	if ($classname == "UnassignedPhone")
	{
		$dname = "serialNumber";
	}

	if (($classname == "Administrator") || ($classname == "License"))
	{	// vvv special case
		// find the GUID of system and provide it as container
		XSearchFor("",2,"(objectclass=System)","");

		$thiscont = $ldapinfo[0]["guid"][0];
		$dn = "GUID=";
	}
	if ($thisupperclassname != "")
	{
		if ($thisparent == "")
		{
			$objclass = "(objectclass=".$thisupperclassname.")";
			if ($thisupperclassname == "Module")
			{
				$objclass = $objclass."(moduleStatus=0)";  // Member(s) only
				$addlogic = true;
			}

		}
		else
		{
			$objclass = "(objectclass=".$thisclassname.")";
		}
	}
	else
	{
		$objclass = "(objectclass=".$thisclassname.")";
		if ($thisclassname == "Module")
		{
			$objclass = $objclass."(moduleStatus=0)";  // Member(s) only
		     	$addlogic = true;
		}

		if ($thisclassname == "UnassignedModule")
		{
			$objclass = "(objectclass=Module)";
			$objclass = $objclass."(|(moduleStatus=1)(moduleStatus=2))";  // NONMember(s) only
		     	$addlogic = true;
		}

	}

	$nents = 0;
	if ($startindex != "")
	{	// looking for a place to start
        
        $startindex = EscapeBrackets($startindex);
        
        //echo "STARTINDEX =========".$startindex."<br><br><br>";

		if ($direction == "back")
		{
			$filt = "(&(".$dname."<=".$startindex.")".$objclass.")";
		}
		else
		{	
            $filt = "(&(".$dname.">=".$startindex.")".$objclass.")";
		}
	}
	else
	{
		$filt = $objclass;
		if ($addlogic)
		{
			$filt = "(&".$filt.")";
		}
	}

	// some list class
	if ($thisupperclassname != "")
	{
		if ($thisparent == "")
		{
			$dn = $dn.$thiscont;
		}
		else
		{
			$dn = "GUID=".$thisparent.",cn=".$thiscont;
		}
		$level = 1;
	}
	else
	{
		$dn = $dn.$thiscont;
		$level = 1;
	}

	$lr = @ldap_list($httpdmgr,$dn,$filt,$allthese,0,13);

	if (!ldap_count_entries($httpdmgr,$lr) && ($level == 1))
	{	// try once more at level 2
		if ($classname != "AutoAttendantKey")
		{	// AutoAttendantKey is a shared classname, do NOT look at level 2
			$lr = @ldap_search($httpdmgr,$dn,$filt,$allthese,0,13);
		}
	}
	if (ldap_count_entries($httpdmgr,$lr))
	{
		$entrycount = ldap_count_entries($httpdmgr,$lr);
		$info = ldap_get_entries($httpdmgr, $lr);

		$resg[$nents] = $info[0]["guid"][0];

    		if (array_key_exists(strtolower($initarray[0]),$info[0]))
		{
			$resn[$nents] = $initarray[0].",".$info[0][strtolower($initarray[0])][0];
			$resn[$nents] = IsolateAttrVal($resn[$nents]);
			if ($pageextension != "")
			{
				$respext[$nents] = $pageextension;
			}
		}
    		if (array_key_exists(strtolower($initarray[1]),$info[0]))
		{
			$display1[$nents] = $info[0][strtolower($initarray[1])][0];
			if ($display1[$nents] != "")
			{
				$display1[$nents] = $initarray[1].",".$display1[$nents];
				$display1[$nents] = IsolateAttrVal($display1[$nents]);
				if ($pageextension != "")
				{
					$respext[$nents] = $pageextension;
				}
			}
		}
    		if (array_key_exists(strtolower($initarray[2]),$info[0]))
		{
			$display2[$nents] = $info[0][strtolower($initarray[2])][0];
			if ($display2[$nents] != "")
			{
				$display2[$nents] = $initarray[2].",".$display2[$nents];
				$display2[$nents] = IsolateAttrVal($display2[$nents]);
				if ($pageextension != "")
				{
					$respext[$nents] = $pageextension;
				}
			}
		}
    		if (array_key_exists(strtolower($initarray[3]),$info[0]))
		{
			$display3[$nents] = $info[0][strtolower($initarray[3])][0];
			if ($display3[$nents] != "")
			{
				$display3[$nents] = $initarray[3].",".$display3[$nents];
				$display3[$nents] = IsolateAttrVal($display3[$nents]);
				if ($pageextension != "")
				{
					$respext[$nents] = $pageextension;
				}
			}
		}
		
		$entrycount--;

		while ($entrycount)
		{
			$nents++;

			$entrycount--;


			$resn[$nents] = "";
			$resg[$nents] = "";
			$display1[$nents] = "";
			$display2[$nents] = "";
			$display3[$nents] = "";

			$resg[$nents] = $info[$nents]["guid"][0];
			
			if ($resg[$nents] != "")
			{
    				if (array_key_exists(strtolower($initarray[0]),$info[0]))
				{
					$resn[$nents] = $initarray[0].",".$info[$nents][strtolower($initarray[0])][0];
					$resn[$nents] = IsolateAttrVal($resn[$nents]);
					if ($pageextension != "")
					{
						$respext[$nents] = $pageextension;
					}
				}
    				if (array_key_exists(strtolower($initarray[1]),$info[0]))
				{
					$display1[$nents] = $info[$nents][strtolower($initarray[1])][0];
					if ($display1[$nents] != "")
					{
						$display1[$nents] = $initarray[1].",".$display1[$nents];
						$display1[$nents] = IsolateAttrVal($display1[$nents]);
						if ($pageextension != "")
						{
							$respext[$nents] = $pageextension;
						}
					}
				}
    				if (array_key_exists(strtolower($initarray[2]),$info[0]))
				{
					$display2[$nents] = $info[$nents][strtolower($initarray[2])][0];
					if ($display2[$nents] != "")
					{
						$display2[$nents] = $initarray[2].",".$display2[$nents];
						$display2[$nents] = IsolateAttrVal($display2[$nents]);
						if ($pageextension != "")
						{
							$respext[$nents] = $pageextension;
						}
					}
				}
    				if (array_key_exists(strtolower($initarray[3]),$info[0]))
				{
					$display3[$nents] = $info[$nents][strtolower($initarray[3])][0];
					if ($display3[$nents] != "")
					{
						$display3[$nents] = $initarray[3].",".$display3[$nents];
						$display3[$nents] = IsolateAttrVal($display3[$nents]);
						if ($pageextension != "")
						{
							$respext[$nents] = $pageextension;
						}
					}
				}

			}
		}
	}
	else
	{
		$emptyind = "";
	}
	
	$resind = 0;
	$adj = 1;
	$loopind = 0;

	if (($direction == "back") && !$addlogic)
	{
		$resind = $nents;
		$adj = -1;
	}

	for ($loopind = 0;$loopind <= $nents;$loopind++)
	{
		$listnames[$loopind] = $resn[$resind];
		if (AGuid($listnames[$loopind]))
		{
		  	$listnames[$loopind] = XGetNameFromGuid($listnames[$loopind],"cn");
		}
//		else if (($classname == "Phone") && ($thisparent != ""))
//		{
//			$listnames[$loopind] = GetDN($listnames[$loopind],"");
//		}

		
		if ($listnames[$loopind] == "")
		{
			$listnames[$loopind] = $emptyind;
		}

		$listguids[$loopind] = $resg[$resind];
		$listpexts[$loopind] = $respext[$resind];
		$listdisplay1[$loopind] = $display1[$resind];
		if (AGuid($listdisplay1[$loopind]))
		{
		  	$listdisplay1[$loopind] = XGetNameFromGuid($listdisplay1[$loopind],"cn");
		}
		$listdisplay2[$loopind] = $display2[$resind];
		if (AGuid($listdisplay2[$loopind]))
		{
		  	$listdisplay2[$loopind] = XGetNameFromGuid($listdisplay2[$loopind],"cn");
		}
		$listdisplay3[$loopind] = $display3[$resind];
		if (AGuid($listdisplay3[$loopind]))
		{
			//if ($classname == "User")
			if (0)
			{
		  		$listdisplay3[$loopind] = GetDN($listdisplay3[$loopind],"cn");
			}
			else
			{
		  		$listdisplay3[$loopind] = XGetNameFromGuid($listdisplay3[$loopind],"cn");
			}
		}
		$resind += $adj;
	}
	$prevname = $listnames[0]; // to go back start here
	$nextname = $listnames[$nents];  // to go forward start here

	// now check to see if previous is possible
	$presn = 0;
	$presg = 0;
	
	$prevpos = 0;
    
    if (($startname != "") && ($direction == "back"))
    {   // not first time for this list
        
        $searchfor = $listnames[0];
        $searchfor = EscapeBrackets($searchfor);
        
        //echo "SEARCHFOR =========".$searchfor."<br><br><br>";
    
        $filt = "(&(".$dname."<=".$searchfor.")".$objclass.")";
        if ($level == 1)
        {
            $lr = @ldap_list($httpdmgr,$dn,$filt,$allthese,0,2);
        }
        else
        {
            $lr = @ldap_search($httpdmgr,$dn,$filt,$allthese,0,2);
        }
        
        $prevpos = ldap_count_entries($httpdmgr,$lr);
        
    }
    else if (($startname != "") && ($search !=2))
    {
        $prevpos = 2;
    }
    
	return $nents;
}

function CreateList($container,$classname,$direction)
{
	
	global $thispagename;
	global $thisdepth;
	global $thisretdepth;
	global $thisnxtdepth;
	global $thisdisplaydepth;

	global $thisguid;
	global $thisdisplayguid;
	global $thisselectguid;

	global $thiscont;
	global $thisdisplaycont;

	global $thisclassname;
	global $thisdisplayclassname;
	global $thisupperclassname;

	global $thisparent;

	global $thisaction;
	global $thisname;
	global $thislistname;
	global $thisattribute;

	global $thisdirection;
	global $thisindex;
	global $thistab;

	global $nameind;
	global $nents;
	global $prevpos;
	global $nextname;
	global $prevname;

	global $pageextension;

	global $resn;
	global $resg;
	global $respext;
	global $display1;
	global $display2;
	global $display3;
	global $listnames;
	global $listguids;
	global $listpexts;
	global $listdisplay1;
	global $listdisplay2;
	global $listdisplay3;

    
	$getnum = 0;
	$limit = $nents;
	
	if ($limit < 12)
	{
		$limit++;  // must display last name
	}
	if ($thisaction == "")
	{
		$thisaction = "modify";  // assume that we need an edit
	}
    if (($thisupperclassname != "") && ($thisparent == ""))
    {
        $_SESSION[ParentTopOfList] = $listnames[0];
        $_SESSION[ParentBottomOfList] = $listnames[$limit-1];
    }
    else
    {
        $_SESSION[TopOfList] = $listnames[0];
        $_SESSION[BottomOfList] = $listnames[$limit-1];
        $_SESSION[ParentBottomOfList] = $_SESSION[ParentTopOfList];
    }

?>
<div style="position: absolute; top: 88px; left: 8px; width: 600px">
	<TABLE width="586" align="center" cellSpacing="1" cellPadding="1" border="0">
		<?
	for ($getnum = 0;$getnum < $limit;$getnum++)
	{
		$pageextension = $listpexts[$getnum]; 
        $hrefid = "hrefid".$getnum;
?>
		<TR>
			<?
		if (($thisupperclassname != "") && ($thisparent == ""))
		{
   
            
?>
			<TD NOWRAP>
				<li>
					<a href='<? echo SetListHrefAction("entitylist",$listguids[$getnum],$container,$listguids[$getnum],$classname,$listnames[$getnum],"","$listnames[0]")?>'><? echo $listnames[$getnum]?></a>
				</li>
			</TD>
			<TD NOWRAP>
				<? echo $listdisplay1[$getnum]?>
			</TD>
			<TD NOWRAP>
				<? echo $listdisplay2[$getnum]?>
			</TD>
			<TD NOWRAP>
				<? echo $listdisplay3[$getnum]?>
			</TD>
			<?
		}
		else
		{
            
?>
			<TD NOWRAP>
				<li>
					<a id="<?echo $hrefid?>" href='<? echo SetListHrefAction($classname,$listguids[$getnum],$container,"",$classname,$listnames[$getnum],"","$listnames[0]")?>'><? echo $listnames[$getnum]?></a>
				</li>
			</TD>
			<TD NOWRAP>
				<? echo $listdisplay1[$getnum]?>
			</TD>
			<TD NOWRAP>
				<? echo $listdisplay2[$getnum]?>
			</TD>
			<TD NOWRAP>
				<? echo $listdisplay3[$getnum]?>
			</TD>
			<?
		}
?>
		</TR>
		<?
	}
?>
	</TABLE>
</div>
<?
}

function ShowList($container,$classname,$startname,$direction,$search)
{



	global $thispagename;
	global $thisdepth;
	global $thisretdepth;
	global $thisnxtdepth;
	global $thisdisplaydepth;

	global $thisguid;
	global $thisdisplayguid;
	global $thisselectguid;

	global $thiscont;
	global $thisdisplaycont;

	global $thisclassname;
	global $thisdisplayclassname;
	global $thisupperclassname;

	global $thisparent;

	global $thisaction;
	global $thisname;
	global $thislistname;
	global $thisattribute;

	global $thisdirection;
	global $thisindex;
	global $thistab;

	global $nameind;
	global $nents;
	global $prevpos;
	global $nextname;
	global $prevname;

	global $resn;
	global $resg;
	global $display1;
	global $display2;
	global $display3;
	global $listnames;
	global $listguids;
	global $listdisplay1;
	global $listdisplay2;
	global $listdisplay3;


	$prevind = 1;
	$nextind = 1;
	$num = 0;

?>
<div style="LEFT: 16px; WIDTH: 400px; POSITION: absolute; TOP: 24px; HEIGHT: 16px" id="titleLa1" align="center">
	<B><? echo $thislistname?>&nbsp;List</B>
</div>
<?
    if (!$direction)
    {
        $direction = "forward";
    }
    if (!$startname)
    {
        $startname = "";
    }
    
	$num = InitList($container,$classname,$startname,$direction,$search);
	if ($num < 12)
	{	// may be at end of list, try again to find out
        if ($direction == "back")
        {
            $num = InitList($container,$classname,$listnames[0],"forward",2);
            if ($num < 12)
            {
                $nextind = 0;
            }
        }
        else
        {
            $nextind = 0;
        }
	}
	if ($prevpos <= 1)
	{
		$prevind = 0;
	}

?>
<FORM METHOD="post" ACTION='<? echo SetFormAction("","entitylist")?>'>
	<img src="back16.gif" onclick="geturlobj.value=0,history.back()" style="POSITION: absolute; TOP: 2px; LEFT:523px">
	<img src="home16.gif" onclick="GoHome()"  style="POSITION: absolute; TOP: 2px; LEFT:594px">
	<INPUT id="homing" style="LEFT: 504px;POSITION: absolute; TOP: 2px;" type="hidden" value="<? echo $thisnxtdepth?>" name="homing">
 	<DIV>
<?

	$add = 1;

	if (($thiscont == "Companies") && 
	    (($thisclassname == "User") || ($thisclassname == "Department"))
	   )
	{
		$add = 0;
	}


	if ((($thisupperclassname == "") || ($thisparent != "")) && 
		($thisaction != "select"))
	{
		if (($add == 1) &&
			($thisclassname != "Trunk") &&
			($thisclassname != "UnassignedPhone") &&
			($thisclassname != "UnassignedModule") &&
			($thisclassname != "WANPort"))
		{
?>
	<div style="Z-INDEX: 193; LEFT: 48px; POSITION: absolute; TOP: 352px">
		<a id="addhref" href='<? echo SetHrefAction("add","")?>'><img src="add.gif" border="0"></a>
	</div>
	
  <?
		}
	}
	if ($nextind != 0)
	{
?>
  <div style="position: absolute; top: 364px; left: 111px">
		<a id="nexthref" href='<? echo SetListHrefAction("entitylist","","","","","","forward",$nextname)?>' target="_self"></a>
	</div>
	
  <img onclick='DispButtonAction("nexthref","")' id="nextButton" style="Z-INDEX: 193; LEFT: 96px; POSITION: absolute; TOP: 352px" src="next.gif" name="nextButton"> 
  <?
	}
	if ($prevind != 0)
	{
?>
  <div style="position: absolute; top: 364px; left: 190px">
		<a id="prevhref" href='<? echo SetListHrefAction("entitylist","","","","","","back",$prevname)?>' target="_self"></a>
	</div>
	
  <img onclick='DispButtonAction("prevhref","")' id="prevButton" style="Z-INDEX: 193; LEFT: 160px; POSITION: absolute; TOP: 352px" src="previous.gif" name="prevButton"> 
  <?
	}
?>
  <div style="position: absolute; top: 396px; left: 176px">
		<a id="findhref" href='<? echo SetListHrefAction("entitylist","","","","","","forward","")?>' target="_self"></a>
	</div>
        
        
  <img onclick='DispButtonAction("findhref","searchname")' id="findbutton" name="findbutton" src="find.gif" STYLE="position: absolute;top: 392px; left:224px" > 
  <INPUT TYPE="TEXT" STYLE="position: absolute; top: 392px; left:34px; width: 176px; height: 24px;" id ="searchname" NAME="searchname" VALUE="" MAXLENGTH="64" size="20">
        
    <INPUT id="geturl" style="visibility:hidden; Z-INDEX: 114; LEFT: 416px; WIDTH: 56px; POSITION: absolute; TOP: 19px; HEIGHT: 18px" type="text" size="4" value="0" name="geturl">
	<?
        $thisselectguid++;

	CreateList($container,$classname,$direction);

?>
					<? echo ErrorReport()?>
				
 	</DIV>
</FORM>
<?
};

// entity add, modify, delete and miscellaneous functions

function DefaultAttrValue($attrname,$defval)
{
	global $attrnum;
	global $tattrs;
	global $tvals;
	global $aattrs;
	global $avals;

	$tattrs = $tattrs.$attrname."\t";	
	$tvals = $tvals.$defval."\t";
	$aattrs[$attrnum] = $attrname;
	$avals[$attrnum] = $defval;
	$attrnum++;

}

function ProcessNewAttrValue($attrname,$distinguishedname,$needguid,$setnewvaltozero)
{


	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;
	global $mgrresult;
	global $actionok;

	global $attrnum;
	global $tattrs;
	global $tvals;
	global $aattrs;
	global $avals;
	global $attrprefix;
	global $attrpostfix;


	global $addpage;
	global $modpage;
	global $ldepth;
	global $cdepth;
	global $ndepth;
	global $rdepth;
	global $currentguid;
	global $guiddn;
	global $atsubobject;
	global $subguid;
	global $cndn;

	global $thispagename;
	global $thisdepth;
	global $thisretdepth;
	global $thisnxtdepth;
	global $thisdisplaydepth;

	global $thisguid;
	global $thisdisplayguid;
	global $thisselectguid;

	global $thiscont;
	global $thisdisplaycont;

	global $thisclassname;
	global $thisdisplayclassname;
	global $thisupperclassname;

	global $thisparent;

	global $thisaction;
	global $thisname;
	global $thislistname;
	global $thisattribute;

	global $thisdirection;
	global $thisindex;
	global $thistab;


	$oldval = "";
	$newval = "";
	$formid = $attrprefix.$attrname.$attrpostfix;

	if (array_key_exists($formid,$_POST))
	{
		$newval = $_POST[$formid];
	}

	if ($thisaction == "modify")
	{
    		$oldval = @$ldapinfo[0][strtolower($attrname)][0];
	}

	$newval = stripslashes($newval);


	if ($needguid)
	{	// need GUID in field
//		if (thisaction == "add")
//		{	// adding this entity means initialising this attribute, currently thisname is used
//			newval = thisname;
//		}
//		else
//		{
			if (array_key_exists($formid."guid",$_POST))
			{
				$newval = $_POST[$formid."guid"];
				if (($newval == "") || ANullGuid($newval))
				{
					$newval = GetZeroGuid();  // to be sure!!
				}
			}
			else
				$newval = $oldval;  // cannot change ... this ensures no action	
//		}
	}



	if ($setnewvaltozero)
	{	// this is a check box, sends NOTHING if unchecked, value if checked
		// of course there is a problem if val = ""  !!!!!
		if ($newval == "")
			$newval = "0";  // unchecked
		else
			$newval = 1;  // must be checked.
	}

	if (($thisaction == "add") || (strlen($newval) != strlen($oldval)) || ($newval != $oldval))
	{
		if (($thisaction == "add") && (($newval == "") || $distinguishedname))
		{
			if ($distinguishedname)
			{
				// must remove trailing spaces (and tabs)
				$newval = trim($newval);
				if ($newval == "")
				{	// cannot handle null string, set another value
					$newval = "\"\"";
				}
				$thisname = $newval;
			}
			return;
		}

		if (($thisaction == "modify") && $distinguishedname)
		{
			XModifyRDN($thisparent,$attrname,$newval,$oldval,$thiscont);    
			if ($mgrresult == "")
			{
				$actionok = 1;
				$thisname = $newval;

				// now reset context (this needs some work!!!!)
				if ($guiddn != "")
				{
					XSearchFor($guiddn,0,"","");
				}
				else if ($cndn != "")
				{
					XSearchFor($cndn,0,"","");
				}
			}
			else
			{
				$actionok = 0;
				//$mgrresult = "";
			}


		 	return;
		}

		if ($newval == "")
		{	// cannot handle null string, set another value
			$newval = "¬NULL¬";
		}


		$tattrs = $tattrs.$attrname."\t";	
		$tvals = $tvals.$newval."\t";
		$aattrs[$attrnum] = $attrname;
		$avals[$attrnum] = $newval;
		$attrnum++;
			
	}
}

function ProcessNewSubAttrValue($cnval,$attrname,$distinguishedname,$needguid,$setnewvaltozero)
{


	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;
	global $mgrresult;
	global $actionok;

	global $attrnum;
	global $tattrs;
	global $tvals;
	global $aattrs;
	global $avals;
	global $attrprefix;
	global $attrpostfix;


	global $addpage;
	global $modpage;
	global $ldepth;
	global $cdepth;
	global $ndepth;
	global $rdepth;
	global $currentguid;
	global $guiddn;
	global $atsubobject;
	global $subguid;
	global $cndn;

	global $thispagename;
	global $thisdepth;
	global $thisretdepth;
	global $thisnxtdepth;
	global $thisdisplaydepth;

	global $thisguid;
	global $thisdisplayguid;
	global $thisselectguid;

	global $thiscont;
	global $thisdisplaycont;

	global $thisclassname;
	global $thisdisplayclassname;
	global $thisupperclassname;

	global $thisparent;

	global $thisaction;
	global $thisname;
	global $thislistname;
	global $thisattribute;

	global $thisdirection;
	global $thisindex;
	global $thistab;

	if ($atsubobject != $cnval)
	{
		$filt = "(cn=".$cnval.")";
	 	XSearchFor($guiddn,1,$filt,"");
		if ($mgrresult != "")
		{	// no valid subobject so ignore it (do not report error)
			$mgrresult = "";
			$_SESSION[ErrorReport]="";
			return;
		}
		$subguid[$cnval] = $ldapinfo[0]["guid"][0];
		$atsubobject = $cnval;
		$attrnum = 0;
		$tattrs = "";
		$tvals = "";
	}

	ProcessNewAttrValue($attrname,$distinguishedname,$needguid,$setnewvaltozero);
}

function AddEntityByGuid($guid,$addattr,$tempval,$classname)
{


	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;
	global $mgrresult;
	global $actionok;

	global $attrnum;
	global $tattrs;
	global $tvals;
	global $aattrs;
	global $avals;
	global $attrprefix;
	global $attrpostfix;


	global $addpage;
	global $modpage;
	global $ldepth;
	global $cdepth;
	global $ndepth;
	global $rdepth;
	global $currentguid;
	global $guiddn;
	global $atsubobject;
	global $subguid;
	global $cndn;

	global $thispagename;
	global $thisdepth;
	global $thisretdepth;
	global $thisnxtdepth;
	global $thisdisplaydepth;

	global $thisguid;
	global $thisdisplayguid;
	global $thisselectguid;

	global $thiscont;
	global $thisdisplaycont;

	global $thisclassname;
	global $thisdisplayclassname;
	global $thisupperclassname;

	global $thisparent;

	global $thisaction;
	global $thisname;
	global $thislistname;
	global $thisattribute;

	global $thisdirection;
	global $thisindex;
	global $thistab;


	$tempname = $thisname;
	$addclass = $thisclassname;

	if ($classname != "")
	{
		$addclass = $classname;
	}

	
	if ($tempval != "")
	{	// must add with temp and modify later
		$tempname = $tempval;
	}
	
	$cndn = $addattr."=".$tempname.",GUID=".$guid;
	XAdd($cndn,$addclass,$attrnum,$tattrs,$tvals);  
	  
	// must now search for this new entity
	// use all (new)attributes to ensure uniqueness

	$cname = "GUID=".$guid;
	$filt = "(&(".$addattr."=".$tempname.")";
	$aind = 0;

	for ($aind = 0;$aind < $attrnum;$aind++)
	{
		$filt = $filt ."(".$aattrs[$aind]."=".$avals[$aind].")";
	}

	$filt = $filt.")";  // close the search string

	XSearchFor($cname,1,$filt,"");
	if (($mgrresult != "") || !$ldapinfo["count"])
	{	// search failure...but we have just added!! Try level 2 search
		$mgrresult = "";
		$_SESSION[ErrorReport] = "";  // do not report this one
		XSearchFor($cname,2,$filt,"");
	}
	if (!$ldapinfo["count"])
	{	// some error
		return;  // nothing else to do		
	}

	$saveguid = $thisguid;
	$thisguid = $ldapinfo[0]["guid"][0];
	$guiddn = "GUID=".$thisguid;
	if ($tempval != "")
	{	// now modify
		XModify($guiddn,1,$addattr,$thisname);    
	}

	if ($mgrresult == "")
	{
		$thisaction = "modify";  // for later
		$actionok = 1;
	}
	else
	{
		$actionok = 0;
		//$mgrresult = "";
	}
	$thisguid = $saveguid;
}

function AddEntityByAttribute($addattr,$searchattr,$classname)
{


	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;
	global $mgrresult;
	global $actionok;

	global $attrnum;
	global $tattrs;
	global $tvals;
	global $aattrs;
	global $avals;
	global $attrprefix;
	global $attrpostfix;


	global $addpage;
	global $modpage;
	global $ldepth;
	global $cdepth;
	global $ndepth;
	global $rdepth;
	global $currentguid;
	global $guiddn;
	global $atsubobject;
	global $subguid;
	global $cndn;

	global $thispagename;
	global $thisdepth;
	global $thisretdepth;
	global $thisnxtdepth;
	global $thisdisplaydepth;

	global $thisguid;
	global $thisdisplayguid;
	global $thisselectguid;

	global $thiscont;
	global $thisdisplaycont;

	global $thisclassname;
	global $thisdisplayclassname;
	global $thisupperclassname;

	global $thisparent;

	global $thisaction;
	global $thisname;
	global $thislistname;
	global $thisattribute;

	global $thisdirection;
	global $thisindex;
	global $thistab;

	global $addguid;


	$addclass = $thisclassname;

	if ($classname != "")
	{
		$addclass = $classname;
	}

	$cndn = $addattr."=".$thisname;
	if ($thisparent != "")
	{
		$cndn = $cndn.",GUID=".$thisparent;
	}
	else
	{
		$cndn = $cndn.",cn=".$thiscont;
	}

	XAdd($cndn,$addclass,$attrnum,$tattrs,$tvals);
	
	// must now search for this new entity
	// use all (new)attributes to ensure uniqueness

	$cname = "";
	if ($thisparent != "")
	{
		$cname = "GUID=".$thisparent.",";
	}
	$cname = $cname."cn=".$thiscont;
	if ($thisname != "\"\"")
	{
		$filt = "(&(".$addattr."=".$thisname.")";
	}
	else
	{
		$filt = "(&";
	}
	$aind = 0;

	for ($aind = 0;$aind < $attrnum;$aind++)
	{
		$filt = $filt ."(".$aattrs[$aind]."=".$avals[$aind].")";
	}

	$filt = $filt.")";  // close the search string


	XSearchFor($cname,1,$filt,"");
	if (!$ldapinfo["count"])
	{	// try one more level
		XSearchFor($cname,2,$filt,"");
	}


	$addguid = "";

	if (!$ldapinfo["count"])
	{	// some error
		return;  // nothing else to do		
	}

	$saveguid = $thisguid;
	$thisguid = $ldapinfo[0]["guid"][0];
	$addguid = $thisguid;
	$guiddn = "GUID=".$thisguid;
	if ($mgrresult == "")
	{
		$thisaction = "modify";  // for later
		$actionok = 1;
		if ($searchattr != "")
		{	// need a different value to search for in list display
			$thisname = $ldapinfo[0][strtolower($searchattr)][0];
		}
	}
	else
	{
		$actionok = 0;
		//$mgrresult = "";
	}
	$thisguid = $saveguid;

}

function AddEntity()
{

	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;
	global $mgrresult;
	global $actionok;

	global $attrnum;
	global $tattrs;
	global $tvals;
	global $aattrs;
	global $avals;
	global $attrprefix;
	global $attrpostfix;


	global $addpage;
	global $modpage;
	global $ldepth;
	global $cdepth;
	global $ndepth;
	global $rdepth;
	global $currentguid;
	global $guiddn;
	global $atsubobject;
	global $subguid;
	global $cndn;

	global $thispagename;
	global $thisdepth;
	global $thisretdepth;
	global $thisnxtdepth;
	global $thisdisplaydepth;

	global $thisguid;
	global $thisdisplayguid;
	global $thisselectguid;

	global $thiscont;
	global $thisdisplaycont;

	global $thisclassname;
	global $thisdisplayclassname;
	global $thisupperclassname;

	global $thisparent;

	global $thisaction;
	global $thisname;
	global $thislistname;
	global $thisattribute;

	global $thisdirection;
	global $thisindex;
	global $thistab;


	if ($thisname != "")
	{
		$cndn = "cn=".$thisname;
		if ($thisparent != "")
		{
			$cndn = $cndn.",GUID=".$thisparent;
		}
		$cndn = $cndn.",cn=".$thiscont;

		XAdd($cndn,$thisclassname,$attrnum,$tattrs,$tvals);    
		if ($thiscont != "VoicemailPorts")
		{	// cannot find voicemailports by cn 
			XSearchFor($cndn,0,"","");
		}
		$saveguid = $thisguid;
		$thisguid = $ldapinfo[0]["guid"][0];
		$guiddn = "GUID=".$thisguid;
		if ($mgrresult == "")  
		{
			$thisaction = "modify";  // for later
			$actionok = 1;

		}
		else
		{
			$actionok = 0;
			//$mgrresult = "";
		}
		$thisguid = $saveguid;
	}
}


function ModifyEntity()
{

	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;
	global $mgrresult;
	global $actionok;

	global $attrnum;
	global $tattrs;
	global $tvals;
	global $aattrs;
	global $avals;
	global $attrprefix;
	global $attrpostfix;


	global $addpage;
	global $modpage;
	global $ldepth;
	global $cdepth;
	global $ndepth;
	global $rdepth;
	global $currentguid;
	global $guiddn;
	global $atsubobject;
	global $subguid;
	global $cndn;

	global $thispagename;
	global $thisdepth;
	global $thisretdepth;
	global $thisnxtdepth;
	global $thisdisplaydepth;

	global $thisguid;
	global $thisdisplayguid;
	global $thisselectguid;

	global $thiscont;
	global $thisdisplaycont;

	global $thisclassname;
	global $thisdisplayclassname;
	global $thisupperclassname;

	global $thisparent;

	global $thisaction;
	global $thisname;
	global $thislistname;
	global $thisattribute;

	global $thisdirection;
	global $thisindex;
	global $thistab;


	if ($attrnum)
	{
		XModify($guiddn,$attrnum,$tattrs,$tvals);    
		if ($mgrresult == "")
		{
			$actionok = 1;
		}
		else
		{
			$actionok = 0;
			//$mgrresult = "";
		}
		XSearchFor($guiddn,0,"","");
	}
	else
	{
		if ($mgrresult == "")
			$actionok = 1;
	}
}

function ModifySubEntity()
{

	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;
	global $mgrresult;
	global $actionok;

	global $attrnum;
	global $tattrs;
	global $tvals;
	global $aattrs;
	global $avals;
	global $attrprefix;
	global $attrpostfix;


	global $addpage;
	global $modpage;
	global $ldepth;
	global $cdepth;
	global $ndepth;
	global $rdepth;
	global $currentguid;
	global $guiddn;
	global $atsubobject;
	global $subguid;
	global $cndn;

	global $thispagename;
	global $thisdepth;
	global $thisretdepth;
	global $thisnxtdepth;
	global $thisdisplaydepth;

	global $thisguid;
	global $thisdisplayguid;
	global $thisselectguid;

	global $thiscont;
	global $thisdisplaycont;

	global $thisclassname;
	global $thisdisplayclassname;
	global $thisupperclassname;

	global $thisparent;

	global $thisaction;
	global $thisname;
	global $thislistname;
	global $thisattribute;

	global $thisdirection;
	global $thisindex;
	global $thistab;


	if ($attrnum && ($atsubobject != -1))
	{
		$subguiddn = "GUID=".$subguid[$atsubobject];
		XModify($subguiddn,$attrnum,$tattrs,$tvals);    
		if ($mgrresult == "")
		{
			$actionok = 1;
		}
		else
		{
			$actionok = 0;
			//$mgrresult = "";
		}
		XSearchFor($subguiddn,0,"","");
	}
	else
	{
		if ($mgrresult == "")
			$actionok = 1;
	}
}

function ErrorReport()
{

	global $httpdmgr;
	global $ldapresult;
	global $ldapinfo;
	global $mgrresult;
	global $actionok;

	global $attrnum;
	global $tattrs;
	global $tvals;
	global $aattrs;
	global $avals;
	global $attrprefix;
	global $attrpostfix;


	global $addpage;
	global $modpage;
	global $ldepth;
	global $cdepth;
	global $ndepth;
	global $rdepth;
	global $currentguid;
	global $guiddn;
	global $atsubobject;
	global $subguid;
	global $cndn;

	global $thispagename;
	global $thisdepth;
	global $thisretdepth;
	global $thisnxtdepth;
	global $thisdisplaydepth;

	global $thisguid;
	global $thisdisplayguid;
	global $thisselectguid;

	global $thiscont;
	global $thisdisplaycont;

	global $thisclassname;
	global $thisdisplayclassname;
	global $thisupperclassname;

	global $thisparent;

	global $thisaction;
	global $thisname;
	global $thislistname;
	global $thisattribute;

	global $thisdirection;
	global $thisindex;
	global $thistab;

	$rep = $_SESSION[ErrorReport];
	if($rep!="")
	{
		$rep ='<div id="error" style="Z-INDEX: 999; LEFT: 10px; WIDTH: 410px; POSITION: absolute; TOP: 10px; HEIGHT: 50px; BACKGROUND-COLOR: pink; color: black;">'.$_SESSION[ErrorReport]."</div>";
	}
	$_SESSION[ErrorReport] = "";
	$mgrresult = "";
//$rep = "";
	return $rep;
}

function  BackAndDisplay($listtype)
{	// this function is called when we need to return to
	// a place in history and display some information
	// must go back (currdepth - retdepth)+1 to ensure in correct place (n.b dummy action page)


	global $cdepth;
	global $rdepth;

	global $thisname;
	global $thisdepth;
	global $thisretdepth;
	global $thisclassname;
	global $thisaction;
    global $thisselectguid;


	$sub = 1;

	$howfar = $cdepth-$rdepth+1;
//	var howfar = cdepth-rdepth;
	$pn = "";

	// get and set relevant depth data
	$GLOBALS[pnarray] = $_SESSION[PNArray];
	$pn = $GLOBALS[pnarray][$rdepth];
	$GLOBALS[indarray] = $_SESSION[INDArray];
	$GLOBALS[indarray][$rdepth] = $thisname;
	$GLOBALS[dirarray] = $_SESSION[DIRArray];
	$GLOBALS[dirarray][$rdepth] = "forward";
	$_SESSION[INDArray] = $GLOBALS[indarray];
	$_SESSION[DIRArray] = $GLOBALS[dirarray];

	$_SESSION[ListBack]++;
    
    $thisselectguid++;


	if ($pn == "entitylist")
	{
		$_SESSION[ListForward]["pn"] = $pn;
		$_SESSION[ListForward]["de"] = $thisdepth;
		$_SESSION[ListForward]["rde"] = $thisretdepth;
		$_SESSION[ListForward]["nde"] = $thisretdepth;
		$_SESSION[ListForward]["cl"] = $thisclassname;
		$_SESSION[ListForward]["act"] = $thisaction;
        $_SESSION[ListForward]["sgu"] =  $thisselectguid;        
		$_SESSION[ListForward]["lb"] = $_SESSION[ListBack];
		$sub = 1;  // entitylist will (or not) request an update
	}

?>
<FORM id="bandf" name="bandf" method="post" action="<? echo $pn?>.php?pn=<? echo $pn?>&sgu=<? echo $thisselectguid?>&de=<? echo $thisdepth?>&rde=<? echo $thisretdepth?>&nde=<? echo $thisretdepth?>&cl=<? echo $thisclassname?>&act=<? echo $thisaction?>&lb=<? echo $_SESSION[ListBack]?>">
	<a id="newhref" href="<? echo $pn?>.php?pn=<? echo $pn?>&sgu=<? echo $thisselectguid?>&de=<? echo $thisdepth?>&rde=<? echo $thisretdepth?>&nde=<? echo $thisretdepth?>&cl=<? echo $thisclassname?>&act=<? echo $thisaction?>&lb=<? echo $_SESSION[ListBack]?>"></a>
	<INPUT id="howfar" type="hidden" value='<? echo $howfar?>'>
	<INPUT id="sendit" type="hidden" value="<? echo $sub?>">
	<IMG id="subimg" height="0" width="0" src="add.gif" onclick='GoBack(document.getElementById("newhref").href,<? echo $howfar?>,<? echo $sub?>)'>
</FORM>
<?

}

function MiscProcessing($listtype)
{


	global $cdepth;
	global $rdepth;
	global $ldepth;

	global $thisaction;
	global $thisguid;
    
	global $thisdisplaydepth;
	global $thisname;
	global $thistab;
	global $thisdepth;
	global $thisaction;
	global $thiscont;
	global $thisparent;
	global $thisclassname;

	global $guiddn;



	$sub = 0;

	if ($thisaction == "delete")
	{	// delete and showlist
		if ($thisguid != "")
		{
			XDelete($guiddn);
		}
		$thisaction = "modify";  // ensure correct action later
		$thisguid = "";  // no longer exists
		$cdepth--;  // to ensure correct action, perhaps some change to href action required

		BackAndDisplay($listtype);
	}
	else
	{
		if ($thisdisplaydepth != "")
		{	// display the relevant entity
			$dd = $thisdisplaydepth;
			$howfar = $cdepth-$dd+1;
			$pn = "";
			// get and set relevant depth data
			$GLOBALS[pnarray] = $_SESSION[PNArray];
			$pn = $GLOBALS[pnarray][$dd];
			$tempname = "";
			if ($dd == $cdepth)
			{
				$sub = 1;
				$dd = $cdepth-1;  // display depth???
				$tempname = $thisname;
			}
			$tempdisplaydepth = $thisdisplaydepth;
			$_SESSION[ListBack]++;
            

			$thisdisplaydepth = "";
			if (($pn == "entitylist") || ($sub == 1))
			{	// entitylist or update in situ, both will request an update
				$sub = 0;  // an update will be requested
				$GLOBALS[dirarray] = $_SESSION[DIRArray];
				$GLOBALS[dirarray][$dd] = "forward";
				$_SESSION[DIRArray] = $GLOBALS[dirarray];
				$GLOBALS[indarray] = $_SESSION[INDArray];
				$GLOBALS[indarray][$dd] = $thisname;
				$_SESSION[INDArray] = $GLOBALS[indarray];

				$_SESSION[ListForward]["pn"] =  $pn;
				$_SESSION[ListForward]["tab"] = $thistab;
				$_SESSION[ListForward]["gu"] =  $thisguid;
				$_SESSION[ListForward]["de"] =  $thisdepth;
				$_SESSION[ListForward]["rde"] = $tempdisplaydepth;
				$_SESSION[ListForward]["nde"] = $tempdisplaydepth;
				$_SESSION[ListForward]["dde"] = $dd;
				$_SESSION[ListForward]["act"] = $thisaction;
				$_SESSION[ListForward]["co"] =  $thiscont;
				$_SESSION[ListForward]["pa"] =  $thisparent;
				$_SESSION[ListForward]["cl"] =  $thisclassname;
				$_SESSION[ListForward]["na"] =  $tempname;
				$_SESSION[ListForward]["lb"] =  $_SESSION[ListBack];
			}
            

?>
<FORM id="bandf" name="bandf" method="post" action="<? echo $pn?>.php?pn=<? echo $pn?>&tab=<? echo $thistab?>&gu=<? echo $thisguid?>&de=<? echo $thisdepth?>&rde=<? echo $tempdisplaydepth?>&nde=<? echo $tempdisplaydepth?>&dde=<? echo $dd?>&act=<? echo $thisaction?>&co=<? echo $thiscont?>&pa=<? echo $thisparent?>&cl=<? echo $thisclassname?>&na=<? echo $tempname?>&lb=<? echo $_SESSION[ListBack]?>">
	<a id="newhref" href="<? echo $pn?>.php?pn=<? echo $pn?>&tab=<? echo $thistab?>&gu=<? echo $thisguid?>&de=<? echo $thisdepth?>&rde=<? echo $tempdisplaydepth?>&nde=<? echo $tempdisplaydepth?>&dde=<? echo $dd?>&act=<? echo $thisaction?>&co=<? echo $thiscont?>&pa=<? echo $thisparent?>&cl=<? echo $thisclassname?>&na=<? echo $tempname?>&lb=<? echo $_SESSION[ListBack]?>"></a>
	<INPUT id="howfar" type="hidden" value='<? echo $howfar?>'>
	<INPUT id="sendit" type="hidden" value='<? echo $sub?>'>
	<IMG id="subimg" height="0" width="0" src="add.gif" onclick='GoBack(document.getElementById("newhref").href,<? echo $howfar?>,<? echo $sub?>)'>
</FORM>
<?
		}
		else if ($rdepth == 0)
		{	// going back to first is (!not) allowed
			// this is a non-list item (i.e. system)
			// go back 2 and re-present first
			$howfar = 2;
			$pn = "";

			// get and set relevant depth data
			$GLOBALS[pnarray] = $_SESSION[PNArray];
			$pn = $GLOBALS[pnarray][1];
			$ldepth = 0;
			$cdepth = 0;
			$_SESSION[ListBack]++;


?>
<FORM id="bandf" name="bandf" method="post" action="first.php?pn=first&de=<? echo $cdepth?>&rde=<? echo $ldepth?>&nde=<? echo $cdepth?>&cl=<? echo $thisclassname?>&act=<? echo $thisaction?>&lb=<? echo $_SESSION[ListBack]?>">
	<a id="newhref" href="first.php?pn=first&de=<? echo $cdepth?>&rde=<? echo $ldepth?>&nde=<? echo $cdepth?>&cl=<? echo $thisclassname?>&act=<? echo $thisaction?>&lb=<? echo $_SESSION[ListBack]?>"></a>
	<INPUT id="howfar" type="hidden" value='<? echo $howfar?>'>
	<INPUT id="sendit" type="hidden" value="1">
	<IMG id="subimg" height="0" width="0" src="add.gif" onclick='GoBack(document.getElementById("newhref").href,<? echo $howfar?>,true)'>
</FORM>
<?


		}
		else
		{	// we have an update (ok). New to return and redisplay

			BackAndDisplay($listtype);
		}
	}

}


?>

<STYLE>
	#trTabList { cursor: hand; text-align: center; font: 10pt Arial; height:20px; } 
	#tdLeftSide { border-left:1px THREEDHIGHLIGHT solid; } 
	#tdRightSide { border-right: 1px THREEDDARKSHADOW solid;} 
	#tblTabControl { position 	: absolute; top: 5px; left: 5px; width: 460px; height: 16px; 
	border-bottom: 1px THREEDDARKSHADOW solid; } 
	#divZero {visibility: hidden} 
	#divOne {visibility: hidden}   
	#divTwo {visibility: hidden} 
	#divThree {visibility: hidden}   
	#divFour { visibility: hidden} 
	#divFive { visibility: hidden}  
	#divSix {visibility: hidden} 
	#divSeven {visibility: hidden}   
</STYLE>



<SCRIPT LANGUAGE=JavaScript SRC=splice.js></SCRIPT>


