<?php
// PJC Jan 2018 - added unlicensed, disabled, suppressdtmf, usertype 
// PJC 09 March 2015 - First Name and Last Name
// PJC 29-Aug-2014  changes to DDI importing and updating. Fixed adding new DDI. Only delete DDI if 'delete' is entered in the field
// 11 April 2014 - updated old extension output and home issue

// bobg 20mar06 31jan07 22mar07 6oct10 29mar12
//header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
$page_id = "064";
include "assist/.access.php";
ini_set('max_execution_time',60);
if(session_id() == '') {
    session_start();
}
/*		foreach ( $_GET as $key=>$value ){
			print "\$_GET[\"$key\"] ==$value<br>";
		}
*/
include "assist/tzone.php"; // include timezone
$script=$_SERVER['SCRIPT_NAME'];
$_SESSION['user'] = array( 'old extension' => 'oldextension', 'extension' => 'telephonenumber', 'name' => 'cn',
		'description' => 'description', 'first name' => 'givenname', 'last name' => 'sn', 'company' => 'company',
		'auto url' =>'autourl', 'call waiting' => 'callwaiting', 'current home' => 'currenthome',
		'department voicemail' => 'departmentvoicemail', 'department voicemail 2' => 'departmentvoicemail2',
		'department voicemail 3' => 'departmentvoicemail3', 'departmentvoicemail 4' => 'departmentvoicemail4',
		'dial plan' => 'dialplan', 'dir auto url' => 'dirautourl', 'disabled' => 'disabled', 'do not disturb' => 'donotdisturb',
		'exdirectory' => 'exdirectory', 'exref' => 'extref', 'follow me' => 'followme', 'follow me to' => 'followmeto', 'forward on busy' => 'forwardonbusy',
		'forward on busy to' => 'forwardonbusyto', 'forward on no answer' => 'forwardonnoanswer',  'forward on no answer to' => 'forwardonnoanswerto',
		'home page' => 'homepage', 'home telephone number' => 'hometelephonenumber', 'initial phone' => 'initialphone', 'locale' => 'locale',
		'location automatic' => 'locationautomatic', 'login access code' => 'loginaccesscode',
		'login idle time' => 'loginidletime', 'mail' => 'mail', 'message archive license' => 'messagearchivelicense', 'message box license' => 'messageboxlicense', 'mobile telephone number' => 'mobiletelephonenumber',
		'no answer time' => 'noanswertime', 'operator console license' => 'operatorconsolelicense', 'outgoing call bar' => 'outgoingcallbar', 'out of office' => 'outofoffice', 'out of office msg' => 'outofofficemsg',
		'park slot base' => 'parkslotbase', 'park slot offset' => 'parkslotoffset', 'pickup alerts' => 'pickupalerts', 'require account coding' => 'requireaccountcoding',
		'sms enabled' => 'smsenabled', 'sms originator' => 'smsoriginator', 'spare1 telephone number' => 'spare1telephonenumber',
		'spare2 telephone number' => 'spare2telephonenumber', 'supervisor of' => 'supervisorof',
		'url' => 'url', 'user class' => 'userclass', 'user display pref' => 'userdisplaypref', 'user type' => 'usertype', 'voicemail access code' => 'voicemailaccesscode',
		'voicemail assistant telephonenumber' => 'voicemailassistanttelephonenumber', 'voicemail enabled' => 'voicemailenabled',
		'ddi' => 'ddi',);
$_SESSION['splicePhone'] = array( 'partner login code' => 'partnerlogincode',
			'proxy server address' => 'proxyserveraddress', 'proxy server port' => 'proxyserverport',
			'screen saver mode' => 'screensavermode', 'screen saver params' => 'screensaverparams' );
$_SESSION['potsPhone'] = array ( 'partner login code' => 'partnerlogincode',
			'caller display len' => 'callerdisplaylen', 'caller display type' => 'callerdisplaytype',
			'off hook working' => 'offhookworking', 'paging port' => 'pagingport',
			'remote pstn' => 'remotepstn', 'remote idle' => 'remoteidle', 'suppress dtmf' => 'suppressdtmf', 'unlicensed port' => 'unlicensed');

$ds = @ldap_connect("127.0.0.1",4000) or exit("EXIT: failed to connect to LDAP");
ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3); // this line required for ldap_rename() to work.
$r = @ldap_bind($ds,"INTERNAL","001122334455") or exit("EXIT: failed to bind to LDAP");

//print "field count=".count($_SESSION['user'])."<br/>";
$sr=@ldap_list($ds,"cn=Users","objectclass=User",array(),0,1);
$info=ldap_get_entries($ds,$sr);
foreach($info[0] as $k => $v) {
	if (is_string($v)) {
		if ($v=="guid") continue;
		if ($v=="objectclass") continue;
		if (strpos($v,"=")) continue;
		if (in_array($v,$_SESSION['user'])) ;
		else {
//			print $v.", ";
			$_SESSION['user'][$v]=$v;
		}
	}
}
//print "field count=".count($_SESSION['user'])."<br/>";

ldap_list($ds,"cn=Self,cn=Modules","objectclass=*",array(),0,0); // setin this to 1 seems to restrict future calls
// get list of all current extensions

function getCurrentExtensions ($ds) {
	$_SESSION['currentExtensions'] = array();
	$_SESSION['currentInitialPhones'] = array();
	$att = array('telephonenumber','initialphone','guid');
	$sr = ldap_list($ds,"cn=users","objectclass=user",$att);
	$info=ldap_get_entries($ds,$sr);
//print "count users = ".$info['count']."<br>";
	for( $n=0; $n<$info['count']; $n++) {
		$t = $info[$n]['telephonenumber'][0];
		$_SESSION['currentExtensions'][$t] = $info[$n]['guid'][0];
		$_SESSION['currentInitialPhones'][$t] = $info[$n]['initialphone'][0];
	}
	ksort($_SESSION['currentExtensions']);
	ksort($_SESSION['currentInitialPhones']);

// print_r ($_SESSION['currentExtensions']);
// print_r ($_SESSION['currentInitialPhones']);
 	return;
}

function getCurrentDialPlans ($ds) {
	$_SESSION['currentDialPlans'] = array();
	$att = array('cn','guid');
	$sr = ldap_list($ds,"cn=dialplans","objectclass=dialplan",$att);
	$info=ldap_get_entries($ds,$sr);
//print "count users = ".$info['count']."<br>";
	for( $n=0; $n<$info['count']; $n++) {
		$t = $info[$n]['cn'][0];
		$_SESSION['currentDialPlans'][$t] = $info[$n]['guid'][0];
	}
// print_r ($_SESSION['currentDialPlans']);
 	return;
}
function getCurrentCompanies ($ds) {
	$_SESSION['currentCompanies'] = array();
	$att = array('cn','guid');
	$sr = ldap_list($ds,"cn=companies","objectclass=company",$att);
	$info=ldap_get_entries($ds,$sr);
//print "count users = ".$info['count']."<br>";
	for( $n=0; $n<$info['count']; $n++) {
		$t = $info[$n]['cn'][0];
		$_SESSION['currentCompanies'][$t] = $info[$n]['guid'][0];
	}
// print_r ($_SESSION['currentCompanies']);
 	return;
}
function getCurrentGroups ($ds) {
	$_SESSION['currentGroups'] = array();
	$att = array('cn','guid');
	$sr = ldap_list($ds,"cn=groups","objectclass=group",$att);

	$info=ldap_get_entries($ds,$sr);
//print "count users = ".$info['count']."<br>";
	for( $n=0; $n<$info['count']; $n++) {
		$t = $info[$n]['cn'][0];
		$_SESSION['currentGroups'][$t] = $info[$n]['guid'][0];
	}
// print_r ($_SESSION['currentGroups']);
 	return;
}
function getCurrentDepartments ($ds) {
	$_SESSION['currentDepartments'] = array();
	$att = array('cn','guid');
	$sr = ldap_list($ds,"cn=departments","objectclass=department",$att);
	$info=ldap_get_entries($ds,$sr);
//print "count users = ".$info['count']."<br>";
	for( $n=0; $n<$info['count']; $n++) {
		$t = $info[$n]['cn'][0];
		$_SESSION['currentDepartments'][$t] = $info[$n]['guid'][0];
	}
// print_r ($_SESSION['currentDepartments']);
 	return;
}
function getCurrentTimeplans ($ds) {
	$_SESSION['currentTimeplans'] = array();
	$att = array('cn','guid');
	$sr = ldap_list($ds,"cn=timeplans","objectclass=timeplan",$att);
	$info=ldap_get_entries($ds,$sr);
//print "count users = ".$info['count']."<br>";
	for( $n=0; $n<$info['count']; $n++) {
		$t = $info[$n]['cn'][0];
		$_SESSION['currentTimeplans'][$t] = $info[$n]['guid'][0];
	}
// print_r ($_SESSION['currentTimeplans']);
 	return;
}
function getCurrentCSModules ($ds) {
	$_SESSION['currentCSModules'] = array();
	$att = array('cn','guid');
	$sr = ldap_list($ds,"cn=modules","(&(objectclass=module)(|(moduletype=1)(moduletype=10)(moduletype=11)(moduletype=12)(moduletype=17)(moduletype=18)(moduletype=19)))",$att);
	$info=ldap_get_entries($ds,$sr);
//print "count users = ".$info['count']."<br>";
	for( $n=0; $n<$info['count']; $n++) {
		$t = $info[$n]['cn'][0];
		$_SESSION['currentCSModules'][$t] = $info[$n]['guid'][0];
	}
// print_r ($_SESSION['currentCSModules']);
 	return;
}
function getCurrentDDIs ($ds) {
	$_SESSION['currentDDIs'] = array();
	$att = array('translateto','numbermatch');
	if ($sr = @ldap_list($ds,"cn=Standard,cn=ddicallplans","objectclass=ddientry",$att)) {
		$info=ldap_get_entries($ds,$sr);
//print "count ddis = ".$info['count']."<br>";
		for( $n=0; $n<$info['count']; $n++) {
			$t = $info[$n]['translateto'][0];
			$p = strpos($t,']');
			if ($p===false) ;
			else $t=substr($t,$p+1);
			$nm = $info[$n]['numbermatch'][0];
			$_SESSION['currentDDIs'][$t] = $nm;
		}
	} else print "no Standard DDIplan ";
//print_r ($_SESSION['currentDDIs']);
 	return;
}

//extract list of extensions fron list like 2001,2003-2011,2020,2030
function getExtn ($s) {
	$extnToDo = array();
	$sa = explode(',',$s);
	foreach($sa as $key => $value) {
		if ($value < 1) continue;
		$sb = explode('-',$value);
		if (! isset($sb[1])) $sb[1]=$sb[0];
		for ($n=$sb[0]; $n<=$sb[1]; $n++) if (isset($_SESSION['currentExtensions'][$n])) $extnToDo[$n] = $_SESSION['currentExtensions'][$n];
	}
	ksort($extnToDo);
	return($extnToDo);
}

// PHP4/5 ver of stripos
function stipos($haystack, $needle){
    return strpos($haystack, stristr( $haystack, $needle ));
}

function setddi($ds, $company, $ddi, $extn) {
	if ($company != "") $company='['.$company.']';
// print $company;
	if ($sr=@ldap_read($ds, "cn=Standard,cn=ddicallplans", "objectclass=*")) {
		$sr = ldap_list ($ds, "cn=Standard,cn=ddicallplans", "translateto=*$extn");
		$info= ldap_get_entries($ds,$sr);
		if ($info['count']>0) {
			$dn=$info[0]['dn'];
			if (stipos($ddi, "delete") !== FALSE) ldap_delete($ds,$dn);
			else {
				$att = array('numbermatch' => $ddi,'translateto' => $company.$extn);
				if (strlen($ddi >=1)) ldap_modify($ds,$dn,$att);
			}
		} else {
			if ($ddi !="") { //no longer add leading 0 to ddi
				$sr = ldap_list($ds,"cn=Standard,cn=ddicallplans","objectclass=ddientry", array('id'));
				$info = ldap_get_entries($ds, $sr); $count = $info['count']-1;
				$orid = $info[$count]['id'][0]+1;				    
			
				$att = array('numbermatch' => $ddi, 'translateto' => $company.$extn, 'id' => $orid, 'objectclass' => 'ddientry',
				'timeplan' => $_SESSION['currentTimeplans']['Standard'] );
            $dn = "numbermatch=".$ddi.", cn=Standard, cn=ddicallplans";
				ldap_add($ds,$dn,$att);
			}
		}
	}
	return;
}

function data50 ($ds,$data) {
	getCurrentExtensions($ds);
	getCurrentDialPlans($ds);
	getCurrentCompanies($ds);
	getCurrentGroups($ds);
	getCurrentDepartments($ds);
	getCurrentTimeplans($ds);
	getCurrentCSModules($ds);
	$_SESSION['type50'] = array();
	foreach($data as $key => $value) {
	print "$value";
		$value = trim(strtolower($value));
		if (in_array($value, array_keys($_SESSION['user']))) {
			$_SESSION['type50']['title'][$key] = $_SESSION['user'][$value];
			$_SESSION['type50']['itemUser'][$key] =1;
		}
		elseif (in_array($value, array_keys($_SESSION['splicePhone']))) {
			$_SESSION['type50']['title'][$key] = $_SESSION['splicePhone'][$value];
			$_SESSION['type50']['itemPcs'][$key] =1;
			if ($_SESSION['type50']['title'][$key] == "partnerlogincode") $_SESSION['type50']['itemPots'][$key] =1;
		}
		elseif (in_array($value, array_keys($_SESSION['potsPhone']))) {
			$_SESSION['type50']['title'][$key] = $_SESSION['potsPhone'][$value];
			$_SESSION['type50']['itemPots'][$key] =1;
		}
		elseif ($value==50);
		else print "-<b>ignored</b>";
		print ", ";
	}
	print "<br/>";
	//print_r($_SESSION['type50']['title']);
	return;
}

function data51 ($ds,$data) {
	unset ($itemUser, $itemPots, $itemPcs, $extension, $oldExtension, $company);
	foreach($data as $key => $value) {
		if ( ! isset($_SESSION['type50']['title'][$key])) continue;
		if ((isset($value[0]) && $value[0]=='=') && (isset($value[1]) && $value[1]=='"')) $value=substr($value,2,strlen($value)-3); //undo the excel ="0" fix
		if ($_SESSION['type50']['title'][$key] == "telephonenumber") {
			$extension=$value;
		}
		elseif ($_SESSION['type50']['title'][$key] == "oldextension") {
			$oldExtension = $value;
			continue;
		}
		elseif ($_SESSION['type50']['title'][$key] == "initialphone") {
			 $p = explode('.',$value);
			 $p[0] = (isset($p[0])) ? $p[0] : NULL;
			 $p[1] = (isset($p[1])) ? $p[1] : NULL;
			 $dn ="cn=$p[1],cn=$p[0],cn=Modules";

			if ($sr=@ldap_read($ds,$dn,"objectclass=*")) {
				$info = ldap_get_entries($ds,$sr);
//	print "count=".$info['count'].",";
//	print $info[0]['guid'][0]." ";
				$itemUser['initialphone'] = $info[0]['guid'][0];
			} else $itemUser['initialphone'] = "00000000-0000-0000-0000-000000000000";
		}
		elseif ($_SESSION['type50']['title'][$key] == "company") {
			if ($value != "" && $_SESSION['currentCompanies'][$value] == "") {
				print "<b>Create Company:</b> $value, ";
				$dn = "cn=$value,cn=Companies";
				$att = array('objectclass' => 'Company', 'description' => 'auto generated by modify.php');
				ldap_add($ds,$dn,$att);
				$dn = "cn=AutoAttendant,cn=$value,cn=Companies";
				$att = array('objectclass' => 'Container');
				ldap_add($ds,$dn,$att);
				$dn = "cn=Contacts,cn=$value,cn=Companies";
				ldap_add($ds,$dn,$att);
				$dn = "cn=Departments,cn=$value,cn=Companies";
				ldap_add($ds,$dn,$att);
				$dn = "cn=MeetMeConferences,cn=$value,cn=Companies";
				ldap_add($ds,$dn,$att);
				$dn = "cn=Users,cn=$value,cn=Companies";
				ldap_add($ds,$dn,$att);
				getCurrentCompanies($ds);
			}
			$_SESSION['currentCompanies'][$value] = (isset($itemUser['company'])) ? $_SESSION['currentCompanies'][$value] : NULL;
			$company =$value;
		}
		elseif ($_SESSION['type50']['title'][$key] == "currenthome") $itemUser['currenthome'] = $_SESSION['currentCSModules'][$value];

		elseif ($_SESSION['type50']['title'][$key] == "dialplan") {
			if (isset($_SESSION['currentDialPlans'][$value]) && $_SESSION['currentDialPlans'][$value] == "") $_SESSION['currentDialPlans'][$value] = "Standard";
			$itemUser['dialplan'] = (isset($_SESSION['currentDialPlans'][$value])) ? $_SESSION['currentDialPlans'][$value] : NULL;
		}
		elseif ($_SESSION['type50']['title'][$key] == "supervisorof") $itemUser['supervisorof'] = (isset($_SESSION['currentGroups'][$value])) ? $_SESSION['currentGroups'][$value] : NULL;
		elseif ($_SESSION['type50']['title'][$key] == "departmentvoicemail") $itemUser['departmentvoicemail'] = (isset($_SESSION['currentDepartments'][$value])) ? $_SESSION['currentDepartments'][$value] : NULL;
		elseif ($_SESSION['type50']['title'][$key] == "departmentvoicemail2") $itemUser['departmentvoicemail2'] = (isset($_SESSION['currentDepartments'][$value])) ? $_SESSION['currentDepartments'][$value] : NULL;
		elseif ($_SESSION['type50']['title'][$key] == "departmentvoicemail3") $itemUser['departmentvoicemail3'] = (isset($_SESSION['currentDepartments'][$value])) ? $_SESSION['currentDepartments'][$value] : NULL;
		elseif ($_SESSION['type50']['title'][$key] == "departmentvoicemail4") $itemUser['departmentvoicemail4'] = (isset($_SESSION['currentDepartments'][$value])) ? $_SESSION['currentDepartments'][$value] : NULL;

		elseif  (isset($_SESSION['type50']['itemUser'][$key])) {
			$title = (isset($_SESSION['type50']['title'][$key])) ? $_SESSION['type50']['title'][$key] : NULL;
			$itemUser[$title] = $value;
		}
		else {
			if  (isset($_SESSION['type50']['itemPots'][$key])) {
				$title = (isset($_SESSION['type50']['title'][$key])) ? $_SESSION['type50']['title'][$key] : NULL;
				$itemPots[$title] = $value;
			}
			if  (isset($_SESSION['type50']['itemPcs'][$key])) {
				$title = (isset($_SESSION['type50']['title'][$key])) ? $_SESSION['type50']['title'][$key] : NULL;
// print "k=$key v=$value, ";
//	6oct10			if (($title=="screensaverparams") && ($value !="") && (substr_count($value,',')!= 2)) {
//					print "screen saver params = ???, ";
//				}
//				else
            $itemPcs[$title] = $value;
			}
		}
	}

	// we have now collected all the data fields - so do any processing
	if ($oldExtension==0) {
		$extnToDo = getExtn($extension);
// print_r( $extnToDo);
	} else {
		$oldExtension = $oldExtension * 1;
		$extnToDo = getExtn($oldExtension);
		$extension = $extension * 1;
		if ($extension == 0) $extension = $oldExtension;
		$itemUser['telephonenumber'] = $extension;
	}
	if (isset($oldextension)) unset($itemUser[$oldextension]);

//print_r($_SESSION['currentInitialPhones']);

	foreach ($extnToDo as $key => $value) {
		print "<b>$key</b>, ";
//print_r ($itemUser);
		if (isset($itemUser['cn'])) {
			if ($itemUser['cn'] != "") ldap_rename($ds,"guid=$value","cn=".$itemUser['cn'],"cn=Users",true);
			unset ($itemUser['cn']);
		}
		if (isset($itemUser['ddi'])) {
			$ddi=$itemUser['ddi'];
			if (isset($itemUser['telephonenumber'])) $n = $itemUser['telephonenumber'];
			else $n = $key;
			setddi($ds,$company,$ddi,$n);
			unset ($itemUser['ddi']);
		}
//print_r($itemUser);
		if (isset($itemUser)) ldap_modify($ds,"guid=$value",$itemUser);
		if (isset($itemPots) || isset($itemPcs)) {
			if (! isset($itemUser['initialPhone'])) $itemUser['initialPhone'] = $_SESSION['currentInitialPhones'][$key];
			if ($itemUser['initialPhone'] != "00000000-0000-0000-0000-000000000000") {
				$dn = "guid=".$itemUser['initialPhone'];
//	print "k=$key v=$value dn=$dn ";
				$sr = ldap_list($ds,$dn,"objectclass=*");
				$info= ldap_get_entries($ds,$sr);
//	print $info[0]['objectclass'][0];
				if ($info['count']>0)	{
					$dn = $info[0]['dn'];
					if ($info[0]['objectclass'][0]=="POTSPhone" && isset($itemPots)) ldap_modify($ds,$dn,$itemPots);
					elseif ($info[0]['objectclass'][0]=="SplicePhone"  && isset($itemPcs)) {
					 	ldap_modify($ds,$dn,$itemPcs);
					}
				}
			}

		}
		unset($itemUser['initialPhone']);

	}
}

function dodump($ds) {

		$filename = "/SpliceCom/Web/download/modify.out.csv";
	if ( ! $fp = fopen($filename,'w')) exit ("EXIT: cannot open file $filename");
	@chmod($filename,0666);
	$title =1;
	getCurrentExtensions ($ds);
	getCurrentDDIs ($ds);
	foreach ($_SESSION['currentExtensions'] as $e_key => $e_value) {
		if ($e_key < $_SESSION['from']) continue;
		if ($e_key > $_SESSION['to']) continue;
		print "<b>$e_key,</b> ";
		$sr = ldap_read($ds,"guid=".$e_value,"objectclass=*");
		$info = ldap_get_entries($ds,$sr);
		if ($title) {
			fwrite($fp,"50");
			foreach ($_SESSION['user'] as $u_key => $u_value) {
				$s=$u_key;
				fwrite($fp,','.$s);
			}
			foreach ($_SESSION['potsPhone'] as $u_key => $u_value) {
				$s=$u_key;
				fwrite($fp,','.$s);
			}
			foreach ($_SESSION['splicePhone'] as $u_key => $u_value) {
				if ($u_value=="partnerlogincode") continue;
				$s=$u_key;
				fwrite($fp,','.$s);
			}
			fwrite($fp,"\n");
			$title = 0;
		}
		fwrite($fp,"51");
		foreach ($_SESSION['user'] as $u_key => $u_value) {
			$s = (isset($info[0][$u_value][0])) ? $info[0][$u_value][0] : NULL;
			if ($u_key=="old extension") $s = $info[0]['telephonenumber'][0]; // output old extension number
			if (($u_value=="initialphone") ||($u_value=="company") || ($u_value=="currenthome") || ($u_value=="dialplan") || ($u_value=="supervisorof")
			|| ($u_value=="departmentvoicemail") || ($u_value=="departmentvoicemail2") || ($u_value=="departmentvoicemail3") || ($u_value=="departmentvoicemail4")
			|| ($u_value=="location")) $s = guidToName($ds,$s);
			if ($u_value=="ddi") $s = (isset($_SESSION['currentDDIs'][$e_key])) ? $_SESSION['currentDDIs'][$e_key] : '';
			filecsv ($fp,$s);
		}

		$phone = $_SESSION['currentInitialPhones'][$e_key];
		$sr = @ldap_list($ds,"guid=".$phone,"partnerlogincode=*");
		$info = @ldap_get_entries($ds,$sr);

		foreach ($_SESSION['potsPhone'] as $u_key => $u_value) {
			$s = (isset($info[0][$u_value][0])) ? $info[0][$u_value][0] : NULL;
			filecsv ($fp,$s);
		}
		foreach ($_SESSION['splicePhone'] as $u_key => $u_value) {
			if ($u_value=="partnerlogincode") continue;
			$s = (isset($info[0][$u_value][0])) ? $info[0][$u_value][0] : '';
			filecsv ($fp,$s);
		}
		fwrite($fp,"\n");
	}
	fclose($fp);
}
function filecsv ($fp,$s) {
	$s=str_replace('"','""',$s);
	if (strpos( $s,',') === false) ;
	else {$s = '"'.$s.'"';}
	if (isset($s[0]) and $s[0]=='0') $s='="'.$s.'"'; // work arround for excel to display leading zero's
	fwrite($fp,','.$s);
}
function guidToName($ds,$guid) {
	if ($guid=="00000000-0000-0000-0000-000000000000") return("");
	$att=array();
	if ( ! $sr = @ldap_read($ds,"guid=".$guid,"objectclass=*",$att)) return ("");
	$info=ldap_get_entries($ds,$sr);
	$s=$info[0]['dn'];
	$s = str_replace('cn=','',$s);
	$sa = explode(',',$s);
	if(count($sa)==3) return($sa[1].'.'.$sa[0]);
	return($sa[0]);
}

// php starts here

if (isset($_GET['download'])) {
	$filename="modify.out.csv";
	$fn = "/SpliceCom/Web/download/".$filename;
	if(is_readable($fn)) {
		$filesize = filesize($fn);
		$filetime =date("r",filemtime($fn));
		$fp=@fopen($fn,"r");
		if($fp)
		{
			header("Accept-Ranges: bytes");
			header("Content-Type: application/octet-stream");
			header("Content-Disposition: attachment; filename=$filename; size=$filesize; modification-date=\"$filetime\"");
       		while (!feof($fp)) {
        		echo(fread($fp, 4096));
    	    }
   	    	fclose ($fp);
			exit;
	    }
	}
	header("HTTP/1.0 404 Not Found");
	exit;
}
?>
<html>
<head>
<title>Modify Users - Via A Spreadsheet</title>
<META HTTP-EQUIV="Expires" CONTENT="0">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<?php
if (isset($_GET['dump00'])) {
}
elseif (isset($_GET['dump0'])) {
?>
<META HTTP-EQUIV="REFRESH" CONTENT="0;URL=modify.php?dump=0">
<?php
}
elseif (isset($_GET['modify0'])) {
?>
<META HTTP-EQUIV="REFRESH" CONTENT="0;URL=modify.php?modify=0">
<?php
}
?>
<meta http-equiv="Content-type" content="text/html; charset=UTF-8"/>
<link href="css/Styles.css" rel="stylesheet" type="text/css">
<script language="javascript">
var popupWindow = null;
function centeredPopup(url,winName,w,h,scroll){
LeftPosition = (screen.width) ? (screen.width-w)/2 : 0;
TopPosition = (screen.height) ? (screen.height-h)/2 : 0;
settings =
'height='+h+',width='+w+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',resizable'
popupWindow = window.open(url,winName,settings)
}
</script>
</head>
<body>
<br/>
<div style="position:absolute; top:8px; right:8px" >
<a href="modify.php?dump00=0">Dump</a>&nbsp;|&nbsp;<a href="modify.php?download=0">Download</a>&nbsp;|&nbsp;<a href="modify.php?upload=0">Upload</a>&nbsp;|&nbsp;<a href="modify.php?modify00=0">Modify</a>&nbsp;|&nbsp;
<img onClick="window.location = '<?php echo $script?>'" src="assist/images/refresh16.gif" alt="refresh" title="refresh" border="0">&nbsp;&nbsp;
<img onClick="centeredPopup('assist/help/help_modify.php','help','600','500','yes');return false" src="assist/images/help16.gif" alt="help" title="help" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'assist/assist.php'" src="assist/images/assist16.gif" alt="manager assist" title="manager assist" border="0">&nbsp;&nbsp;
<img onClick="window.location = 'index.php'" src="assist/images/home16.gif" alt="home" title="home" border="0">
</div>
<div id="contain">
<h2><img src='assist/images/backup.png' style="vertical-align:middle;">&nbsp;Modify Users - Via A Spreadsheet</h2>
<?php
if (isset($_GET['upload'])){
?>

<p>Use the "Browse..." button to select the .csv file on your PC which you wish to upload to the Call Server.</p>
<table><form name="upload" id="upload" ENCTYPE="multipart/form-data" action="modify.php" method="post">
<tr><td>File Name: </td><td><input type="file" id="userfile" name="userfile"></td></tr>
<tr><td> </td><td><input type="submit" name="upload" value="Upload"></td></tr>
</form></table>
<p>This file will then be saved as "/SpliceCom/Web/download/modify.csv" on the Call Server.</p>

<?php
}
elseif (isset($_POST['upload'])){
	$filename = "/SpliceCom/Web/download/modify.csv";
	if (move_uploaded_file($_FILES['userfile']['tmp_name'], $filename )){
		@chmod ($filename, 0666);
		print "<p>File uploaded and saved as \"/SpliceCom/Web/download/modify.csv\"</p>";
		print "<p>Use the modify link at the top of the page to activate modifications.</p>";
	} else print "rats...";
	print "<p>Done</p>";
}
elseif (isset($_GET['dump00'])) {
?>

<p>Select extension range to be dumped to file:</p>
<form>From: <input type="text" name="from" value="1" /> To: <input type="text" name="to" value="9999" />&nbsp;&nbsp;&nbsp;<input type="submit" name="dump0" value="Dump" /></form>

<?php
}
elseif (isset($_GET['dump0'])) {
	$_SESSION['from']=$_GET['from'];
	$_SESSION['to']=$_GET['to'];
?>

<p>The Call Server is now dumping the Users configuration to file. The file "/SpliceCom/Web/download/modify.out.csv"
can be edited locally using "telnet" and "vi" or downloaded to your PC using the download link at the top of the page.</p>
<p><b>Please wait until it completes...</b><br/><br/></p>

<?php
}
elseif (isset($_GET['dump'])) {
	dodump($ds);
	print "<p>Done</p>";
}
elseif (isset($_GET['modify00'])) {
?>

<p>You are about to modify the live configuration of the maximiser system.</p>
<p>Do you want to <a href="modify.php?modify0=0">continue</a> and modify the system, or  <a href="modify.php">cancel</a>.</p>
<p>Modifying certain fields (details to come) will cause the Users to re-register and thus will interrupt active calls.
Excel likes to remove the leading zeros from telephone numbers - do you know they are OK in this file?
It is recommended that you delete columns you do not want / understand from your Excel spreadsheet before you modify the system.  </p>

<?php
}
elseif (isset($_GET['modify0'])) {
?>

<p>The Call Server is now updating the Users configuration from the file "/SpliceCom/Web/download/modify.csv".
You can upload this from your PC using the upload link at the top of the page.</p>
<p><b>Please wait until it completes...</b><br/><br/></p>

<?php
}
elseif (isset($_GET['modify']) || (isset($argv[1]) && $argv[1]=="modify")) {
	$_SESSION['continue_from']=0;
	$file = "/SpliceCom/Web/download/modify.csv";
	$fp = @fopen ($file, "r") or exit("EXIT: failed to open $file");
	$to=0;
	while ($data = fgetcsv ($fp, 3000, ",")) {
		if ($_SESSION['continue_from'] > $to++ ) continue;
		if ($data[0] == 0) { $s = implode(",", $data); print "<br/>$s<br/>"; }
	    elseif ($data[0] == 50) { print "[50] User column titles: "; data50($ds,$data); }
		elseif ($data[0] == 51) { print "[51] "; data51($ds,$data); }
	}
	fclose($fp);
	print "<p>Done</p>";
} else {
?>

<p>You can now keep your user configuration details in an Excel spreadsheet and update the maximiser from it.</p>
<p>This modify.php web page allows you to modify the Current Users configuration on the Call Server using a Comma Seperated Variable
(.csv) file. The file can be Uploaded to the Call Server from your PC or edited via "telnet"
in "/SpliceCom/Web/download/modify.csv" using "vi". You can also dump the current user config to a file "/SpliceCom/Web/download/modify.out.csv" and download it to your PC. <br/><br/>
The file can be edited using Microsoft Excel. Excel is very good at removing the leading 0 from telephone numbers!
To ease this problem they are formated in the .csv file as ="02087654321" which keeps the correct format until edited by Excel.
It is recommended that you define columns containing telephone numbers as "text", save any work in progress as a .xls, and only save work as
a .csv file for upload.</p>
<p>The file format is best explained by dumping a configuration to file. Columns can be in any order apart from the initial key, any unknown
columns will be ignored. The extension column can contain multiples e.g. "2001,2002,2100-2199,2999"<br/>
so a simple file like: <br/>
50,extension,caller display len<br/>
51,1-9999,16<br/><br/>
Will set the Caller Display Length to 16 digits for all users.</p>

<?php
}
?>
</div>
</body>
</html>

