<?php
// PJC 27-06-2018 version download updates
// PJC 13-04-2018 nice
// PJC 20-03-2018 System Check Update
// PJC 19-01-2018 SV String Update
// PJC 22-09-2015 S8000 Extract
// PJC 16-06-2015 PCS582 Update
// PJC 08-05-2015 IGM Support
// PJC 01-05-2015 S8000 / MAP support updates
// PJC 23-03-2015 PCS5x3 Support
// PJC 11-09-2014 Reset Poweroff value to disabled
// PJC 10-09-2014 Added Warning for Reboot When Free	
// PJC 05-09-2014 Extract patch / root	
// PJC 03-09-2014 Reboot When Free
// PJC 12-06-2014 Trunk firmware support
// PJC 01-01-2014 NSG Support - uses CS5100 firmware
// PJC 01-01-2014 PCS542 Support
// PJC OCT2013 S8000 Support
// bobg 21jul07 27jul09 3aug 26aug 30aug 13oct 6sep11 28mar12
// auto download of maximiser software using rsync
// for auto update I suggest the following /etc/crontab entry:  4 22 * * * root php -n /WebManager/patch.php > /logs/patch.log

$mode = (isset($argv[1]) && $argv[1] =="webpatch") ? '1' : '0'; // 1 = webpatch  0 = cli;
include "assist/tzone.php"; // include timezone
// find linux version
	exec ('cat /proc/version', $version);
	$version = $version[0];

if (isset($_SERVER['HTTP_HOST'])) die("Run from command line.");

$ds = ldap_connect("127.0.0.1",4000);
if ( ! $ds) {
	echo "LDAP connect failure<br>";
} else {
$r = ldap_bind($ds,"INTERNAL","0123456");
	if ( ! $r) {
		echo "LDAP bind failure<br>";
		$ds = false;
	}
}

$sr = ldap_read($ds,"cn=Self,cn=Modules","objectclass=*"); 
$info = ldap_get_entries($ds,$sr); 
$self = $info[0]['location'][0];

$sr = ldap_read($ds,"cn=$self,cn=Modules","objectclass=module"); 
$info = ldap_get_entries($ds,$sr); 
$productversion = $info[0]['productversion'][0];

if (strpos($productversion, 'SV') !== false) {
	$system="SV";
} else if (strpos($productversion, 'S8') !== false) {
	$system="S8";
} else {
	$system="CS";
}

if(substr(phpversion(),0,1)=="4") $verCommand = "ver";  else $verCommand = "/SpliceCom/bin/ver";
if (stri4pos($version,'centos') !== false) $rsyncCommand = "rsync"; else $rsyncCommand = "/usr/sbin/rsyncd ";

$state = array('no','yes','when free');
//get array of updates required
$fg='/SpliceCom/ftp/firmware.get';
if (!file_exists($fg)) {
   $fp=fopen($fg,'w');
   $s  = "# Remove hashes to enable individual downloads, you may specify versions or leave blank for the latest.\n#admin = 3.2.1117\n";
   $s .= "# Below is a list of software available.\n";
   $s .= "#admin\n#trunk\n#igm\n#pcs100\n#pcs400.patch\n#pcs410\n#pcs5xx\n#pcs5x1\n#pcs54x\n#pcs5x3\n#pcs582\n#voicemail\n#svvoicemail\n#root\n";
   $s .= "# pcs400 - This part of the pcs400 software is stored on the call server, it is stable so only needs loaded once.\n#pcs400\n";
   $s .= "# Remove the # from the line below to reboot the call server if required.\n#poweroff = 1\n\n";
   $s .= "server = max.splicecom.com::max\n";
   $s .= "versions = firmware.latest\n";
   fputs($fp,$s);
   fclose($fp);
   chmod($fg,0666);
   print "Created $fg - a default config file.\n";
}


$a=file($fg);
$get = array();
foreach( $a as $k => $v) {
   if (trim($v)=="") continue;
   if($v[0]=='#') continue;
   $aa=explode('=',$v);
   if (isset($aa[1])) $get[trim($aa[0])]=trim($aa[1]); else $get[trim($aa[0])]="";
}
//get couple of config items
$poweroff ="0";
if (isset($get['poweroff']) and $get['poweroff']==1){
   $poweroff=1;
   //unset ($get['poweroff']);
   print "poweroff = $poweroff\n";
}

if (isset($get['poweroff']) and $get['poweroff']==2){
   $poweroff=2;
   print "poweroff = $poweroff\n";
   // reset poweroff = 0 
   $data = file('/SpliceCom/ftp/firmware.get');
   $data = array_map('replace_a_line',$data);
   f_p_c('/SpliceCom/ftp/firmware.get', implode('', $data));
   
   	if ($mode == '0') { // if run from CLI not via webpatch create warnings
	    $host=$_SERVER['REMOTE_ADDR'];
	    
	    //$ds = ldap_connect("127.0.0.1",4000);
   		//$r = ldap_bind($ds,"INTERNAL","0123456");
   		$warn = "Manager Assist : <b>Patch Reboot When Free Selected</b> @ ".date("r",time())." - ".$host;
		$item = array ('dowarning'=> $warn); ldap_modify($ds,"cn=Commands",$item);
		
		$fh = fopen("/SpliceCom/Web/download/managerassist.log", 'a') or die("can't open file");
		$msg = "Manager Assist : Patch Reboot When Free Selected @ ".date("r",time())." - $host\n";
		fwrite($fh, $msg); fclose($fh);
	}

}

if (isset($get['server'])) {
   $server = $get['server'];
   unset ($get['server']);
   print "server = $server\n";
} else $server="max.splicecom.com::max";
if (substr($get['versions'],0,9)=='firmware.') {
   $fv = $get['versions'];
   unset ($get['versions']);
   print "versions = $fv\n";
} else $fv="firmware.latest";
if (isset($get['copy'])) {  //copy download e.g copy = /voicemail/max/
   $copy=$get['copy'];
   unset($get['copy']);
   if (substr($copy,-1,1) != '/') $copy=$copy.'/';
   print "copy = $copy\n";
}
if (isset($get['delay'])) {
   if ($get['delay']>0) $z=$get['delay']; else $z=100;
   unset($get['delay']);
   print "delay = $z minutes maximum, may be overridden by command line. ".$argv[1]."\n";
   if (isset($argv[1])) $z=$argv[1];
   if($z) $z=rand(1,$z*60);
   print "sleep = $z seconds\n";
   sleep($z);
}
print "start = ".date("Y-m-d H:i")."\n";
//get latest file list
print "\nDownloading items requested in file $fg from $server.\n";
$cmd =  "$rsyncCommand -av $server/$fv /tmp/";
system($cmd,$rv);
if ($rv) die ("\nWARNING: RSYNC FAILED to $server/$fv error: $rv\n");
$a=file("/tmp/$fv");
foreach( $a as $k => $v) {
   if (trim($v)=="") continue;
   if($v[0]=='#') continue;
   $aa=explode('=',$v);
   $ver_new[trim($aa[0])]=trim($aa[1]);
}


//tidy up get list
foreach($get as $k => $v) {
	
	if ($k=="admin") {
		if ($system=="S8") {
			$get[$k] = (strlen($v) >=1) ? $v : $ver_new["admin"];   
		} elseif ($system=="SV") {
			$get[$k] = (strlen($v) >=1) ? $v : $ver_new["SV1000"];
			if (strtoupper(substr($get[$k], 0, 2)) != 'SV') $get[$k] = 'SV'.$get[$k];
		} else {
			$get[$k] = (strlen($v) >=1) ? $v : $ver_new[$k];
		}
	} else {
		$get[$k] = (strlen($v) >=1) ? $v : $ver_new[$k];
	}
	
   //if ($v=="") $get[$k]=$ver_new[$k];
   if ($get[$k]=="") unset($get[$k]);
}
krsort($get);

// we now know what files we want
function version ($cmd) {
   $r=exec($cmd);
   $ver=trim($r);
   $sp=strrpos($ver,' ');
   $ver=substr($ver,$sp+1);
   $ver=str_replace(array('(',')'),array('.',''),$ver);
   print "$ver\n";
   return ($ver);
}

//go thru items


foreach($get as $k => $v){
   if ($k != "poweroff") 
		if (!isset($ver_new[$k])) $ver_new[$k] ='';
		
		if ($k == 'poweroff') continue;
		if ($v != $ver_new[$k]) $s = " available: ".$ver_new[$k].","; else $s = "";
		if ($system == 'SV' && trim($k) == 'admin') $s = " available: ".$ver_new['SV1000'].",";
		
	 
	 
   print ($k=="poweroff") ? "\n##### $k ##### requested: $state[$v]\n" : "\n##### $k #####$s requested: $v, currently: ";
   if ($k=="pcs100" or $k=="pcs400.patch" or $k=="igm" or $k=="pcs410" or $k=="pcs480" or $k=="pcs5xx" or $k=="pcs5x1" or $k=="pcs54x" or $k=="pcs5x3" or $k=="pcs582" or $k=="trunk"){
      if     ($k=="pcs100") $ver=version("$verCommand -j /SpliceCom/ftp/tftp/pcs100.jffs2");
      elseif ($k=="igm") $ver=version("$verCommand /SpliceCom/ftp/tftp/s6xxx.rdimg");
      elseif ($k=="pcs400.patch") $ver=version("$verCommand -j /SpliceCom/ftp/tftp/pcs400-32M.jffs2");
      elseif ($k=="pcs410") $ver=version("$verCommand -j /SpliceCom/ftp/tftp/pcs410-256M.jffs2");
      elseif ($k=="pcs480") $ver=version("$verCommand -f tpcs -j /SpliceCom/ftp/tftp/pcs410-256M.jffs2");
      elseif ($k=="pcs5xx") $ver=version("$verCommand -f tpcs -j /SpliceCom/ftp/tftp/pcs5xx-256M.jffs2");
      elseif ($k=="pcs5x1") $ver=version("$verCommand -f tpcs -j /SpliceCom/ftp/tftp/pcs5x1-256M.jffs2");
      elseif ($k=="pcs54x") $ver=version("$verCommand -f tpcs -j /SpliceCom/ftp/tftp/pcs54x-256M.jffs2");
      elseif ($k=="pcs5x3") $ver=version("$verCommand -f tpcs -j /SpliceCom/ftp/tftp/pcs5x3-256M.jffs2");
      elseif ($k=="pcs582") $ver=version("$verCommand -f tpcs -j /SpliceCom/ftp/tftp/pcs5lxg-256M.jffs2");
      elseif ($k=="trunk")  { $ver=version("$verCommand /SpliceCom/ftp/tftp/tm5204-256M.rdimg"); $k="tm52xx"; } // firmware.get file uses trunk file is named tm52xx

      if ($v==$ver) continue;
      print "Downloading...$ver\n";
	  print "Firmware...$k.$v.tar.gz\n\n";
      $cmd = "$rsyncCommand -av $server/$k.$v.tar.gz /SpliceCom/ftp/";
      system($cmd,$rv);
      if ($rv) continue;
      if (isset($copy)) {
         $cmd = "$rsyncCommand -av /SpliceCom/ftp/$k.$v.tar.gz $copy";
         system($cmd,$rv);
      }
      $cmd = "cd /SpliceCom/ftp/tftp/; nice -10 tar -xzvf /SpliceCom/ftp/$k.$v.tar.gz; rm /SpliceCom/ftp/$k.$v.tar.gz";
      system($cmd,$rv);
   }

  if ($k=="voicemail" || $k=="svvoicemail"){
      if (file_exists("/SpliceCom/ftp/Voicemail.$v.tar.gz")) continue;
      print "Downloading...\n";
      $cmd = "$rsyncCommand -av $server/Voicemail.$v.tar.gz /SpliceCom/ftp/";
	  print "Firmware...Voicemail.$v.tar.gz\n\n";
      system($cmd,$rv);
   }
   
   if ($k=="pcs400"){
      print "Downloading...\n";
	  print "Firmware...pcs400.$v.tar.gz\n\n";
      $cmd = "$rsyncCommand -av $server/pcs400.$v.tar.gz /SpliceCom/ftp/";
      system($cmd,$rv);
      if ($rv) continue;
      if (isset($copy)) {
         $cmd = "$rsyncCommand -av /SpliceCom/ftp/pcs400.$v.tar.gz $copy";
         system($cmd,$rv);
      }
      $cmd = "cd /; nice -10 tar -xzf /SpliceCom/ftp/pcs400.$v.tar.gz ";
      system($cmd,$rv);
   }
   if ($k=="admin" or $k=="root"){
      if(substr(phpversion(),0,1)=="4") $ver =version("$verCommand /SpliceCom/AdminModule");  else $ver=version("$verCommand /SpliceCom/bin/AdminModule");
      if ($v==$ver) continue;
      //identify host
      $host="?";
      $h=file_get_contents("/etc/hosts");
      if (strpos($h,"CALLSERVER")) $host="callserver";
      if (strpos($h,"REMOTECS")) $host="rcallserver";
      if (strpos($h,"CS5100")) $host="cs5100";
      if (strpos($h,"NSG5500")) $host="cs5100"; // uses same file as CS5100
      if (strpos($h,"CS5108")) $host="cs5108";
      if (file_exists("/SpliceCom/initscripts/suse")) $host="SoftPBX"; //added
//      print "[$host] ";
      if ($host=="?") {
         print "host undetermined (not 5100 etc)\n";
         continue;
      }
	  
      if ($host==="SoftPBX") { //added
	  
	  if (file_exists("/SpliceCom/apache2/install.conf")) {
		  $host = "SV1000-Linux"; 
		  $model = "SV1000";
	  } else {
		  $host = "S8000-Linux";
		  $model = "S8000";
	  }
	  
	  if ($k=="admin") $fa="/SpliceCom/ftp/$host.tar.gz";
      print "Downloading...\n";
	  print "Firmware...$host.$v.tar.gz\n\n";
	  
	  if (file_exists($fa)){
         if ($k=="admin") $cmd = "mv $fa /SpliceCom/ftp/$host.$v.tar.gz ";
         system($cmd,$rv);
      }
      if ($k=="admin") $cmd = "$rsyncCommand -av $server/$host.$v.tar.gz /SpliceCom/ftp/";
      system($cmd,$rv);
	  if ($rv) continue;
      if (isset($copy)) {
         if ($k=="admin") $cmd = "$rsyncCommand -av /SpliceCom/ftp/$host.$v.tar.gz $copy";
         system($cmd,$rv);
      }

	  $sr = ldap_read($ds,"cn=System","objectclass=system",array('diagnosticengineeringpassword')); $info = ldap_get_entries($ds,$sr);
	  $password = $info[0]['diagnosticengineeringpassword'][0];
	  
	  if ($k=="admin") $cmd = "echo $password | sudo -S mv /SpliceCom/ftp/$host.$v.tar.gz /home/splicecom/$host.tar.gz";
	  echo "Moving $host.$v.tar.gz -> /home/splicecom/$host.tar.gz\n";
      system($cmd,$rv);
	  
	  if ($k=="admin") $cmd = "echo $password | sudo -S nice -10 tar -zxvf /home/splicecom/$host.tar.gz -C /home/splicecom";
	  echo "Extracting $host.tar.gz -> /home/splicecom/$model\n\n";
      system($cmd,$rv);
	  
	  echo "$model files extracted.\n\nVia the command line using SSH or terminal, run the following commands to upgrade the $model:\n <strong>cd /home/splicecom/$model<strong>\n</strong>sudo ./install.SUSE -net</strong>\n";
	  	  
	  } else {	  //added
      if ($k=="admin") $fa="/SpliceCom/ftp/$host.patch.tar.gz"; else $fa="/SpliceCom/ftp/$host.root.tar.gz";
      if (file_exists($fa)){
         if ($k=="admin") $cmd = "mv $fa /SpliceCom/ftp/$host.patch.$v.tar.gz "; else $cmd = "mv $fa /SpliceCom/ftp/$host.root.$v.tar.gz ";
         system($cmd,$rv);
      }
      if ($k=="admin") $cmd = "$rsyncCommand -av $server/$host.patch.$v.tar.gz /SpliceCom/ftp/";
      else $cmd = "$rsyncCommand -av $server/$host.root.$v.tar.gz /SpliceCom/ftp/";
      system($cmd,$rv);
      if ($rv) continue;
      if (isset($copy)) {
         if ($k=="admin") $cmd = "$rsyncCommand -av /SpliceCom/ftp/$host.patch.$v.tar.gz $copy"; else $cmd = "$rsyncCommand -av /SpliceCom/ftp/$host.root.$v.tar.gz $copy";
         system($cmd,$rv);
      }
      if ($k=="admin") $cmd = "mv /SpliceCom/ftp/$host.patch.$v.tar.gz $fa"; else $cmd = "mv SpliceCom/ftp/$host.root.$v.tar.gz $fa";
      system($cmd,$rv);
      
       print "Extracting file...\n\n";
       sleep(10);
      	  $cmd = "cd /SpliceCom/ftp/; nice -10 gzip -d $fa";
      	  system($cmd,$rv);
      	  if ($rv=="1") {
	      	  print "ERROR: Corrupted file - DELETED - Please Try Again\n";
	      	  $cmd = "cd /SpliceCom/ftp/; rm $fa";
	      	  system ($cmd,$rv);
	      	  if ($rv=="1") print "ERROR: Unable To Remove File - Please Manually Remove\n";
	      	  exit;
      	  } else {
	      	  print "File Successfully Extracted\n";
	      	  $fa = substr($fa, 0, -3);
      	  }
  	} // added
   }
}

if (isset($fa) and file_exists($fa)) {
   if (isset($poweroff) && $poweroff=='1' && substr(phpversion(),0,1)!="5") {
      print "\nPoweroff command issued.\n";
      //$ds = ldap_connect("127.0.0.1",4000);
	  //$r = ldap_bind($ds,"INTERNAL","0123456");
      $ent["doreboot"] = "1";
	  ldap_modify($ds,"cn=Commands",$ent);
  } else if (isset($poweroff) && $poweroff=='2' && substr(phpversion(),0,1)!="5") {
	  echo "\nWaiting For System To Become Free\n";
	  /////////
	  
	//if (!@ldap_bind($ldap = @ldap_connect("127.0.0.1",4000),"INTERNAL","0123456")) exit('ERROR: LDAP bind failed');
		$check = "2"; $count = 0;
  		$continue = TRUE;
  	while ($continue) {
	  	//$active = ldap_count_entries($ldap,ldap_search($ldap,'cn=Calls','(&(objectclass=CallRecord)(connectedtonumber>=1))'));
	  	  	$active = ldap_count_entries($ds,ldap_search($ldap,'cn=Calls','(objectclass=CallRecord)'));
    	if ($active === 0) {
	     	print "\nPoweroff command issued.\n";
      		//$ds = ldap_connect("127.0.0.1",4000);
	  		//$r = ldap_bind($ds,"INTERNAL","0123456");
      		$ent["doreboot"] = "1";
	  		ldap_modify($ds,"cn=Commands",$ent);
	     	break;
     	} else {
	     	$time = date("H:i:s", time()); 
          	if($count % 4 == 0) echo "$active Live Call/s Detected - $time\n"; $count++;
     	}
     	sleep($check);
  	}
	  ////////
	  
	  
  }
	else print "\nPoweroff required, but not enabled in $fg file.\n";
}
if (isset($get['root']) or isset($get['pcs400'])) {
   $a=file($fg);
   $fp=fopen($fg,'w');
   foreach( $a as $k => $v) {
      $s = ltrim($v);
      if(substr($s,0,4)=='root') continue;
      if(substr($s,0,6)=='pcs400' and substr($s,6,1)!='.') continue;
      fputs($fp,$s);
   }
   fclose($fp);
   chmod($fg,0666);
   print "root and/or pcs400 entry removed from $fg to avoid repeat downloads.\n";
}
print "\n".date("Y-m-d H:i")." Done.\n";

function stri4pos($haystack, $needle){
    return strpos($haystack, stristr( $haystack, $needle ));
}

function replace_a_line($data) {
	if (substr( $data, 0, 8 ) === "poweroff") { return "poweroff = 0\n"; }
   	return $data;
}

// PHP4/5 ver of file_put_contents
function f_p_c($filename, $data)
{
  if( $file = fopen($filename, 'w') )
  {
    $bytes = fwrite($file, is_array($data) ? implode('', $data) : $data);
    fclose($file); return $bytes;
  }
}

ldap_close($ds);
?>