<?php

/*
 
NEW: 
 sc_vm_open_session()
 return the $context of the following transactions
 
 sc_vm_close_session($context);
 closed and cleans up the previously established context
 
OLD:
 splicecom_userid_to_mailboxes($userid)	
 returns list of voicemail mailbox accounts with that userid (crsid at Cambridge). e.g. splicecom_userid_to_mailboxes('ijl20') returns ['34702','48427'] ( currently 'hard-coded' for testing)

REPLACED WITH: 
 sc_vm_userid_to_mailboxes($context,$userid)
 return an array of voicemail mailbox account including guids etc.  e.g. result[0] = first mailbox  result[0]['cn'][0] will give their name

 
OLD:
 splicecom_mailbox_to_guid($mailbox)	
 returns the guid of the voicemail mailbox account e.g. splicecom_mailbox_to_guid('34702') returns "fac20000-539c-0216-8567-0017f2938f90" ( currently 'hard-coded' for testing)
 
OLD:
 splicecom_voicemail_list($mailbox_guid)	
 returns a list of voicemail wav filenames (excluding the '.wav' suffix) for that mailbox
REPLACED WITH: 
 sc_vm_voicemail_list($context,$mailbox_guid)
 return an array of voicemail messages including missed calls etc for that mailbox
 
 key fields are:-
 answered   = 0 or 1 , 1=answered
 messageId = blank or message_id, if it has a message id then a wav will exist and it is a voicemail message
 messageState = blank or Old - marks if the message has been read
 messageType = voice,voiceMail  sub-system that added the message also SMS

OLD:
 splicecom_voicemail_data($mailbox_guid, $voicemail_guid)	
 returns the meta-data for that voicemail, by reading the '.msg' file
REPLACED WITH:
 see sc_vm_voicemail_list

OLD:
 splicecom_delete_voicemail($mailbox_guid, $voicemail_guid)	
 deletes that voicemail (not yet implemented - can the '.wav' and '.msg' simply be deleted?)
REPLACED WITH:
 sc_vm_delete_voicemail($context,$mailbox_guid,$voicemail_message_guid,$voicemail_message_id)
 delete the specified voicemail (make take some seconds post the transaction for the message to be deleted by the VM server)

OLD:
 splicecom_forward_voicemail($mailbox_guid_from, $voicemail_guid, $mailbox_guid_to)	
 forwards that voicemail - it is not possible to do this with voice annotation (not yet implemented - can the '.wav' and '.msg' be copied, perhaps with an additional '.msg' entry?)
REPLACED WITH:
 sc_vm_forward_voicemail($context,$mailbox_guid,$voicemail_message_guid,$voicemail_message_id,$target)
 sc_vm_forward_voicemail_to_email($context,$mailbox_guid,$voicemail_message_guid,$voicemail_message_id,$target)
 forward the specific voicemail to the target specified - if this is another mailbox (by number) then ok, if it is a group name then does group sending, if email then sends to email

OLD:
 splicecom_get_email($mailbox)	
 returns [email_status, email_address] where email_status is 'none' or 'forward_notify' or 'forward_attach' and email_address is the address set for email forwarding. E.g. splicecom_get_email('34702')
REPLACED WITH:
 sc_vm_get_email($context,$mailbox_guid)
 return an array of EMAIL VoicemailContacts

OLD:
 splicecom_set_email($mailbox, $email_status, $email_address)	
 sets the email forwarding status of a mailbox. E.g. splicecom_set_email('34702','forward_attach','ijl20@cam.ac.uk')
NEW:
 sc_vm_set_email($context,$mailbox_guid,$contact_guid,$method,$email)
 set the email forwarding method and email address for a specific VoicemailContact
 
 methods are :-
 VMMethodAlert=1, VMMethodDeliver=2, VMMethodCopy=3 , VMMethodAccess=4, VMMethodPrompt=5, VMMethodDeliverAndDelete=6, VMMethodDeliverNew=7, VMMethodDeliverLink=8

 sc_vm_add_email($context,$mailbox_guid,$method,$email)
 Adds an email forwarding method and email address

 sc_vm_delete_email($context,$mailbox_guid,$contact_guid)
 Deletes the email forwarding method
 
OLD:
 splicecom_set_pin($mailbox,pin)	
 sets the mailbox pin. E.g. splicecom_set_pin('34702','1234')
NEW:
 sc_vm_set_pin($context,$mailbox_guid,$pin)
 set the mailbox pin
 
*/


function sc_vm_open_session()
{
    $context = array();

    // **************  CONFIGURATION ***********************//
    $context['voicemailPort']="13";     // Set this to the id of the voicemail port you are controlling

    $context['ldapserver']="127.0.0.1";   // Set this to the primary LDAP server you using
    $context['ldapuser']="INTERNAL";      // Set this to the user/manager leave as INTERNAL if on local machine
    $context['ldappassword']="001122334455";  // Set this to the password leave as 001122334455 on local machine
    
// **************  END CONFIGURATION ***********************//
    
    $context['ds']=ldap_connect($context['ldapserver'], 4000) or die("LDAP connect failure\n");
    ldap_bind($context['ds'], $context['ldapuser'], $context['ldappassword']) or die("LDAP bind failure\n");
    
    $sr = ldap_read($context['ds'],"cn=".$context['voicemailPort'].",cn=VoicemailPorts","objectclass=VoicemailPort");
    $context['voicemailPortInfo'] = ldap_get_entries($context['ds'],$sr);
    
//    print_r($context['voicemailPortInfo']);
    
    return $context;
}

function sc_vm_close_session($context)
{
    ldap_close($context['ds']);
}

function sc_vm_userid_to_mailboxes($context,$userid)
{
    $sr=ldap_search($context['ds'],"","GlobalExtRef>=".$userid,Array(),0,10);
    $info=ldap_get_entries($context['ds'],$sr);
    $result = array();
    foreach( $info as $item)
    {
        if( $item['extref'][0]==$userid )
        {
//            print "Valid Mailbox =" . $item['cn'][0] . "\n";
            $result[] = $item;
        }
    }
    return $result;
}

function sc_vm_message_list($context,$mailbox_guid)
{
    // Basic version assumes this IS the correct server so dont do Home lookup just yet.
    // this will need to be added to deal with multi server solutions
    $sr = ldap_list($context['ds'],"cn=".$mailbox_guid,"objectclass=Message");
    $info = ldap_get_entries($context['ds'],$sr);
    return $info;
}

function  sc_vm_delete_voicemail($context,$mailbox_guid,$voicemail_message_guid,$voicemail_message_id)
{
    // Add a command to the voicemail interface to delete the message
    $info['objectclass']="VoicemailCommand";
    ldap_add($context['ds'],"command=MessageDelete ".$mailbox_guid. " " . $voicemail_message_id . ",cn=".$context['voicemailPortInfo'][0]['guid'][0],$info);
    // do an instant remove of the message for display purposes
    ldap_delete($context['ds'],"GUID=".$voicemail_message_guid);
}

function sc_vm_forward_voicemail($context,$mailbox_guid,$voicemail_message_guid,$voicemail_message_id,$target)
{
    // Add a command to the voicemail interface to delete the message
    $info['objectclass']="VoicemailCommand";
    ldap_add($context['ds'],"command=MessageForward ".$mailbox_guid. " " . $voicemail_message_id . " " . $target . ",cn=".$context['voicemailPortInfo'][0]['guid'][0],$info);
}

function sc_vm_forward_voicemail_to_email($context,$mailbox_guid,$voicemail_message_guid,$voicemail_message_id,$target)
{
    // Add a command to the voicemail interface to delete the message
    $info['objectclass']="VoicemailCommand";
    ldap_add($context['ds'],"command=MessageForwardEmail ".$mailbox_guid. " " . $voicemail_message_id . " " . $target . ",cn=".$context['voicemailPortInfo'][0]['guid'][0],$info);
}

function sc_vm_get_email($context,$mailbox_guid)
{
    $sr = ldap_list($context['ds'],"cn=".$mailbox_guid,"(&(objectclass=VoicemailContact)(type=2))");
    $info = ldap_get_entries($context['ds'],$sr);
    return $info;
}

function sc_vm_set_email($context,$mailbox_guid,$contact_guid,$method,$email)
{
//    set the email forwarding method and email address for a specific VoicemailContact
    $values['method']=$method;
    $values['telephoneNumber']=$email;
    ldap_modify( $context['ds'], "cn=" . $contact_guid , $values);
}

function sc_vm_add_email($context,$mailbox_guid,$method,$email)
{
//    Adds an email forwarding method and email address
    $values['objectclass']="VoicemailContact";
    $values['type']="2";
    $values['method']=$method;
    ldap_add( $context['ds'], "telephoneNumber=" . $email .",cn=". $mailbox_guid , $values);
}

function sc_vm_delete_email($context,$mailbox_guid,$contact_guid)
{
//    Deletes the email forwarding method
    ldap_delete($context['ds'],"cn=" . $contact_guid );
}

function sc_vm_set_pin($context,$mailbox_guid,$pin)
{
    $values['voicemailAccessCode']=$pin;
    ldap_modify($context['ds'],"cn=".$mailbox_guid,$values);
}

?>
